% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.epicontacts}
\alias{plot.epicontacts}
\title{Plot epicontacts objects}
\usage{
\method{plot}{epicontacts}(x, node_color = "id", method = c("visNetwork",
  "graph3D"), thin = TRUE, ...)
}
\arguments{
\item{x}{An \code{\link{epicontacts}} object}

\item{node_color}{An integer or a character string indicating which attribute column
in the linelist should be used to color the nodes.}

\item{method}{A character string indicating the plotting method to be used;
available values are "visNetwork" and "graph3D"; see details.}

\item{thin}{A logical indicating if the data should be thinned so that only
cases with contacts should be plotted.}

\item{...}{Further arguments passed to the plotting methods.}
}
\description{
This function plots \code{\link{epicontacts}} objects using various
approaches. The default method uses \code{\link{vis_epicontacts}}.
}
\details{
This function is merely a wrapper for other plotting functions in
the package, depending on the value of \code{method}:

\itemize{

\item \code{visNetwork}: calls the function \code{\link{vis_epicontacts}}

\item \code{graph3D}: calls the function \code{\link{graph3D}}

}
}
\examples{
if (require(outbreaks)) {
## example using MERS outbreak in Korea, 2014
head(mers_korea_2015[[1]])
head(mers_korea_2015[[2]])

x <- make_epicontacts(linelist = mers_korea_2015[[1]],
                      contacts = mers_korea_2015[[2]], directed=TRUE)

\dontrun{
plot(x)
plot(x, "place_infect")
plot(x, "loc_hosp", legend_max = 20, annot = TRUE)
plot(x, "place_infect", node_shape = "sex",
     shapes = c(M = "male", F = "female"))
plot(x, 4)
plot(x, 4, method = "graph3D")
}
}
}
\seealso{
\code{\link{vis_epicontacts}}, which uses the package
  \code{visNetwork}, and \code{\link{codeawesome}} for icon codes.
}
\author{
Thibaut Jombart (\email{thibautjombart@gmail.com})
}
