% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toffice.R
\name{toffice}
\alias{toffice}
\title{export graph to MS office}
\usage{
toffice(
  figure = NULL,
  format = "pptx",
  filename = "temp.pptx",
  nr = 1,
  nc = 1,
  irow = 1,
  icol = 1,
  onsame = FALSE,
  title = "",
  left = 0.15,
  top = 0.15,
  append = FALSE,
  width = 4,
  height = 4,
  devsize = FALSE,
  units = "in"
)
}
\arguments{
\item{figure}{plot figure function}

\item{format}{file format}

\item{filename}{output filename}

\item{nr, nc}{two numbers to indicate the figures will be drawn in
an nr-by-nc array on the device by columns  or rows, respectively.}

\item{irow, icol}{two number to indicate which row or column for the figure to be drawn}

\item{onsame}{Boolean value show to draw on same slide or not}

\item{title}{title for the figure}

\item{left, top}{two numbers which gives the number of lines of margin to be specified
on the left and right sides of the plot}

\item{append}{append or not}

\item{width}{width of the output figure}

\item{height}{height of the output figure}

\item{devsize}{Boolean value show use device size or not (default = FALSE)}

\item{units}{the units in which to return the value – inches, cm, or pixels (device units)}
}
\description{
export graph to MS office
}
\examples{
if(interactive()){
plot(mtcars$mpg, mtcars$disp)
toffice(filename = file.path(tempdir(), "mtcars.pptx"), format = "pptx")
## use ggplot2
ggplot(mtcars, aes(mpg, disp, color = factor(cyl))) + geom_point()
toffice(filename = file.path(tempdir(), "mtcars.pptx"),format = "pptx")
}
}
\author{
Kai Guo
}
