% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_raster.R
\name{split_raster}
\alias{split_raster}
\title{Split raster into tiles}
\usage{
split_raster(
  file,
  s = 2,
  outputDir,
  gdalinfoPath = NULL,
  gdal_translatePath = NULL
)
}
\arguments{
\item{file}{full path to a raster}

\item{s}{division applied to each side of the raster (s=2 -> 4 tiles)}

\item{outputDir}{path and directory name for output}

\item{gdalinfoPath}{path to gdalinfo binary. Set to \code{NULL} if 
default search path is sufficient.}

\item{gdal_translatePath}{path to gdal_translate binary. 
Set to \code{NULL} if default search path is sufficient.}
}
\value{
Rasters are written to the output directory.
}
\description{
Splits a rasterLayer into tiles
}
\details{
GDAL must be installed for this function to work.
To determine if the default search paths are sufficient,
you can type in R \code{Sys.which('gdalinfo')} and \code{Sys.which('gdal_translate')}.
If a path is returned, then you can leave those arguments as \code{NULL}.
}
\examples{
\dontrun{
# Find example rasters
rasterFiles <- list.files(system.file('extdata', package='envirem'), full.names=TRUE)
tmin1file <- grep('tmin_1\\.', rasterFiles, value=TRUE)

We will split this raster into 4 tiles, that will be written to disk.
split_raster(tmin1file, s = 2, outputDir = '~/temp/', gdalinfoPath = NULL, 
		gdal_translatePath = NULL)
}
}
\references{
GDAL. 2015. GDAL - Geospatial Data Abstraction Library: Version 1.11.3, 
Open Source Geospatial Foundation, \url{http://gdal.org}
}
\author{
Pascal Title
}
