% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/climaticMoistureIndex.R
\name{climaticMoistureIndex}
\alias{climaticMoistureIndex}
\title{Climatic Moisture Index}
\usage{
climaticMoistureIndex(annualPrecip, PET, precipScale = 1)
}
\arguments{
\item{annualPrecip}{rasterLayer of annual precipitation (bioclim 12)}

\item{PET}{rasterLayer of annual potential evapotranspiration}

\item{precipScale}{integer; scaling factor for the precipitation data, see \link{envirem}
for additional details.}
}
\value{
rasterLayer ranging from -1 to +1.
}
\description{
Generate climatic moisture index.
}
\details{
\code{P/PET - 1} when \code{P < PET} \cr
\code{1 - PET/P} when \code{P >= PET}
}
\examples{
\donttest{
# Find example rasters
rasterFiles <- list.files(system.file('extdata', package='envirem'), full.names=TRUE)
env <- stack(rasterFiles)

# identify the appropriate layers
meantemp <- grep('mean', names(env), value=TRUE)
solar <- grep('solrad', names(env), value=TRUE)
maxtemp <- grep('tmax', names(env), value=TRUE)
mintemp <- grep('tmin', names(env), value=TRUE)

# read them in as rasterStacks
meantemp <- stack(env[[meantemp]])
solar <- stack(env[[solar]])
maxtemp <- stack(env[[maxtemp]])
mintemp <- stack(env[[mintemp]])
tempRange <- abs(maxtemp - mintemp)

# get monthly PET
pet <- monthlyPET(meantemp, solar, tempRange)

# get mean annual PET
annualPET <- sum(pet)

climaticMoistureIndex(env[['bio_12']], annualPET)
}
}
\references{
Willmott, C. & Feddema, J. (1992). A More Rational Climatic Moisture Index. 
\emph{The Professional Geographer}, \strong{44}, 84-88.

Vörösmarty, C.J., Douglas, E.M., Green, P.A. & Revenga, C. (2005). Geospatial 
Indicators of Emerging Water Stress: An Application to Africa. 
\emph{AMBIO: A Journal of the Human Environment}, \strong{34}, 230-236.
}
\author{
Pascal Title
}
