% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sva.R
\name{svaupload}
\alias{svaupload}
\title{Get the corrected data after SVA for metabolanalyst}
\usage{
svaupload(xset, lv = NULL)
}
\arguments{
\item{xset}{xcmsset object}

\item{lv}{group information}
}
\value{
csv files for both raw and corrected data for metabolanalyst if SVA could be applied
}
\description{
Get the corrected data after SVA for metabolanalyst
}
\examples{
\dontrun{
library(faahKO)
cdfpath <- system.file("cdf", package = "faahKO")
cdffiles <- list.files(cdfpath, recursive = TRUE, full.names = TRUE)
xset <- xcmsSet(cdffiles)
xset <- group(xset)
xset2 <- retcor(xset, family = "symmetric", plottype = "mdevden")
xset2 <- group(xset2, bw = 10)
xset3 <- fillPeaks(xset2)
svaupload(xset3)
}
}
