% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recplot2.R
\name{enve.recplot2.findPeaks.emauto}
\alias{enve.recplot2.findPeaks.emauto}
\title{Enveomics: Recruitment Plot (2) Emauto Peak Finder}
\usage{
enve.recplot2.findPeaks.emauto(x, components = seq(1, 10),
  criterion = "aic", merge.tol = 2L, verbose = FALSE, ...)
}
\arguments{
\item{x}{An \code{\link{enve.RecPlot2}} object.}

\item{components}{A vector of number of components to evaluate.}

\item{criterion}{Criterion to use for components selection. Must be one of:
\code{aic} (Akaike Information Criterion),
\code{bic} or \code{sbc} (Bayesian Information Criterion or Schwarz Criterion).}

\item{merge.tol}{When attempting to merge peaks with very similar sequencing depth, use
this number of significant digits (in log-scale).}

\item{verbose}{Display (mostly debugging) information.}

\item{...}{Any additional parameters supported by \code{\link{enve.recplot2.findPeaks.em}}.}
}
\value{
Returns a list of \code{\link{enve.RecPlot2.Peak}} objects.
}
\description{
Identifies peaks in the population histogram using a Gaussian Mixture
Model Expectation Maximization (GMM-EM) method with number of components
automatically detected.
}
\author{
Luis M. Rodriguez-R [aut, cre]
}
