% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enpls.fs.R
\name{enpls.fs}
\alias{enpls.fs}
\title{Ensemble Partial Least Squares for Measuring Feature Importance}
\usage{
enpls.fs(x, y, maxcomp = NULL, cvfolds = 5L, reptimes = 500L,
  method = c("mc", "boot"), ratio = 0.8, parallel = 1L)
}
\arguments{
\item{x}{Predictor matrix.}

\item{y}{Response vector.}

\item{maxcomp}{Maximum number of components included within each model.
If not specified, will use the maximum number possible (considering
cross-validation and special cases where n is smaller than p).}

\item{cvfolds}{Number of cross-validation folds used in each model
for automatic parameter selection, default is \code{5}.}

\item{reptimes}{Number of models to build with Monte-Carlo resampling
or bootstrapping.}

\item{method}{Resampling method. \code{"mc"} (Monte-Carlo resampling)
or \code{"boot"} (bootstrapping). Default is \code{"mc"}.}

\item{ratio}{Sampling ratio used when \code{method = "mc"}.}

\item{parallel}{Integer. Number of CPU cores to use.
Default is \code{1} (not parallelized).}
}
\value{
A list containing two components:
\itemize{
\item \code{variable.importance} - a vector of variable importance
\item \code{coefficient.matrix} - original coefficient matrix
}
}
\description{
Measuring feature importance with ensemble partial least squares.
}
\examples{
data("alkanes")
x = alkanes$x
y = alkanes$y

set.seed(42)
fs = enpls.fs(x, y, reptimes = 50)
print(fs)
plot(fs)
}
\author{
Nan Xiao <\url{http://nanx.me}>
}
\seealso{
See \code{\link{enpls.od}} for outlier detection with
ensemble partial least squares regressions.
See \code{\link{enpls.fit}} for fitting ensemble partial least
squares regression models.
}

