% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_glm.R
\name{predict_glm}
\alias{predict_glm}
\title{Extension of glm predict to generate predictions of different types}
\usage{
predict_glm(
  model,
  newdata,
  data = NULL,
  extrapolation_type = "E",
  restricted_vars = NULL,
  type = "response"
)
}
\arguments{
\item{model}{a \code{glm} object.}

\item{newdata}{a data.frame or matrix with the new data to project the
predictions.}

\item{data}{data.frame or matrix of data used in the model calibration step.
Default = NULL.}

\item{extrapolation_type}{(character) to indicate extrapolation type of model.
Models can be transferred with three options: free extrapolation ('E'),
extrapolation with clamping ('EC'), and no extrapolation ('NE').
Default = 'E'.}

\item{restricted_vars}{(character) a vector containing the names of the
variables that will undergo clamping or no extrapolation. For clamping,
these variables are set to minimum and maximum values established for the
max and min values within calibration values. For no extrapolation, the
variables outside calibration limits became NA. If no specific names are
provided, the value is set to NULL by default, indicating that clamping (EC)
or no extrapolation (NE) will be applied to all variables. Ignore if
extrapolation_type = 'E'.}

\item{type}{(character) the type of prediction required. For a default
binomial model the default predictions are of log-odds (probabilities on
logit scale). The default, "response", returns predicted probabilities.}
}
\value{
A \code{SpatRaster} object or a vector with predictions.
}
\description{
Obtains predictions from a fitted generalized linear model objects. It also
allows the clamping option to restrict extrapolation in areas outside the
calibration area.
}
\examples{
# Load fitted model
data("sel_fit", package = "enmpa")

# Load raster layers to be projected
env_vars <- terra::rast(system.file("extdata", "vars.tif", package = "enmpa"))

# Prediction
pred <- predict_glm(sel_fit$glms_fitted$ModelID_7, newdata = env_vars,
                    data = sel_fit$data)
terra::plot(pred)
}
