% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_glm.R
\name{predict_glm}
\alias{predict_glm}
\title{Extension of glm predict to generate predictions of different types}
\usage{
predict_glm(
  model,
  newdata,
  clamping = FALSE,
  var_to_clamp = NULL,
  type = "response"
)
}
\arguments{
\item{model}{a \code{glm} object.}

\item{newdata}{a data.frame or matrix with the new data to project the
predictions.}

\item{clamping}{(logical) whether to clamp values to a minimum and maximum
value, that are established for the max and min values within calibration
values. Default = FALSE.}

\item{var_to_clamp}{(character) a vector containing the names of the variables
that will undergo clamping. By default, if no specific names are provided,
the value is set to NULL, which indicates that clamping will be applied to
all variables. Ignore if clamping = FALSE.}

\item{type}{(character) the type of prediction required. For a default
binomial model the default predictions are of log-odds (probabilities on
logit scale). The default, "response", returns predicted probabilities.}
}
\value{
A \code{SpatRaster} object or a vector with predictions.
}
\description{
Obtains predictions from a fitted generalized linear model objects. It also
allows the clamping option to restrict extrapolation in areas outside the
calibration area.
}
\examples{
# Load fitted model
data("sel_fit", package = "enmpa")

# Load raster layers to be projected
env_vars <- terra::rast(system.file("extdata", "vars.tif", package = "enmpa"))

# Prediction
pred <- predict_glm(sel_fit$ModelID_7, newdata = env_vars)
terra::plot(pred)
}
