% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleRast.r
\name{sampleRast}
\alias{sampleRast}
\title{Sample random points from a raster with/out replacement}
\usage{
sampleRast(x, n, adjArea = TRUE, replace = TRUE, prob = TRUE)
}
\arguments{
\item{x}{\code{SpatRaster} object.}

\item{n}{Positive integer. Number of points to draw.}

\item{adjArea}{If \code{TRUE} (default) then adjust probabilities so sampling accounts for cell area.}

\item{replace}{If \code{TRUE} (default) then sample with replacement.}

\item{prob}{If \code{TRUE} (default) then sample cells with probabilities proportional to cell values. If \code{adjArea} is also \code{TRUE} then probabilities are drawn proportional to the product of cell area * the value of the cell.}
}
\value{
2-column matrix with longitude and latitude of random points.
}
\description{
This function returns coordinates randomly located on a raster where cells can be sampled with replacement (if desired) and where the probability of selection is proportionate to the cell value, cell area, or the product of cell value times cell area.
}
\examples{

library(terra)
r <- rast()
nc <- ncell(r)
r[] <- 1:nc
rands1 <- sampleRast(r, 10000)
rands2 <- sampleRast(r, 10000, adjArea=FALSE)
rands3 <- sampleRast(r, 10000, prob=FALSE)
rands4 <- sampleRast(r, 10000, adjArea=FALSE, prob=FALSE)

oldPar <- par(mfrow=c(2, 2))

plot(r, main='adjArea = TRUE & prob = TRUE')
points(rands1, pch='.')
plot(r, main='adjArea = FALSE & prob = TRUE')
points(rands2, pch='.')
plot(r, main='adjArea = TRUE & prob = FALSE')
points(rands3, pch='.')
plot(r, main='adjArea = FALSE & prob = FALSE')
points(rands4, pch='.')

par(oldPar)

}
\seealso{
\code{\link[terra]{spatSample}}
}
