% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treatmentEffect.R
\name{treatmentEffect}
\alias{treatmentEffect}
\title{Endogenous switching regression}
\usage{
treatmentEffect(
  Results,
  data,
  OutcomeDep,
  SelectDep,
  OutcomeCov,
  SelectCov,
  treatEffect
)
}
\arguments{
\item{Results}{Estimated endogenous switching regression model.}

\item{data}{a data frame. Data for running the regression analysis.}

\item{OutcomeDep}{character. Dependent variable in the outcome equation.}

\item{SelectDep}{character. Dependent variable in the Selection model. The variable must be binary (0 or 1).}

\item{OutcomeCov}{character vector. Covariates in the outcome equation.}

\item{SelectCov}{character vector. Covariates in the selection equation.}

\item{treatEffect}{TRUE/FALSE. Show average treatment effects or expected outcome values.}
}
\value{
A data table that reports the average treatment effects or a list of two tables reporting expected outcome values.
}
\description{
This function calculates average treatment effects and heterogeneity effects from an estimated endogenous switching regression model.
}
