% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enaAscendency.R
\name{enaAscendency}
\alias{enaAscendency}
\title{Calculates the Ascendency of an Ecological Network}
\usage{
enaAscendency(x = "network object")
}
\arguments{
\item{x}{A network object.}
}
\value{
\item{H}{Total flow diversity (MacArthur 1955).  Uses the Shannon
Information measure (aka Boltzmann entropy) applied to the individual flows.
} \item{AMI}{Returns the Average Mutual Information (AMI) in a network. AMI
provides a measure of the constraints placed on a given peice of energy
matter moving through a network (Patricio et al. 2006) } \item{Hr}{Residual
uncertainty that remains about the flow distribution once the ecosystem
structure is specified (Hr = H - AMI). } \item{ASC}{Returns the ascendnecy
of a network.  Ascendency is a scaled form of AMI relative to the total
system throughput (Ulanowicz 1997; 2004).  Total system throughput is the
sum of all activity in a network (Kay et al. 1989).} \item{OH}{Returns the
overhead of a network.  Overhead is the proportion of the capacity in a
network that is not used as ascendency (Ulanowicz 2004).} \item{CAP}{Returns
the capacity of a network.  Capacity is defined as the sum of ascendency and
overhead (Ulanowicz 2004).} \item{ACS.CAP}{Returns the proportion of
capacity used by ascendency.} \item{OH.CAP}{Returns the proportion of
capacity used by overhead.} \item{robustness}{Returns the robustness of the
network.} \item{ELD}{Returns the Effective Link Density of the network(c)
(Ulanowicz et al. 2014).} \item{TD}{Returns the Trophic Depth of the
network(r) (Ulanowicz et al. 2014).} \item{A.input}{Returns the input
ascendnecy of a network.} \item{A.internal}{Returns the internal ascendnecy
of a network.} \item{A.export}{Returns the export ascendnecy of a network.}
\item{A.respiration}{Returns the respiration ascendnecy of a network.}
\item{OH.input}{Returns the input overhead of a network.}
\item{OH.internal}{Returns the internal overhead of a network.}
\item{OH.export}{Returns the export overhead of a network.}
\item{OH.respiration}{Returns the respiration overhead of a network.}
\item{CAP.input}{Returns the input capacity of a network.}
\item{CAP.internal}{Returns the internal capacity of a network.}
\item{CAP.export}{Returns the export capacity of a network.}
\item{CAP.respiration}{Returns the respiration capacity of a network.}
}
\description{
Calculates the average mutual information (AMI), ascendency,
overhead, and capacity of input-output networks.  It also returns
the ratios of ascendency and overhead to capacity. These metrics
describe the organization of flow in an ecological network
(Ulanowicz 1997).
}
\details{
This and other Ulanowicz school functions require that export and
respiration components of output be separately quantified.
}
\examples{
data(troModels)
enaAscendency(troModels[[6]])
}
\references{
Kay, J.J., Graham, L.A., Ulanowicz, R.E., 1989. A detailed guide
to network analysis. p. 15-61 In: Wulff, F., Field, J.G., Man, K.H. (eds.)
Network analysis in marine ecology. Coastal Estuarine Study Serries.
Springer-Verlag, Berlin.

Patrico, J., Ulanowicz, R.E., Pardal, M.A., Marques J.C., 2004. Ascendency
as an ecological indicator: a case study of estuarine pulse eutrophication.
Estuar. Coast Shelf S. 60, 23-35.

Ulanowicz, R.E. and Norden, J.S., 1990. Symmetrical overhead in flow
networks. International Journal of Systems Science, 21(2), pp.429-437.

Ulanowicz, R.E., 1997. Ecology, The Ascendent Perspective. Columbia
University Press, New York.

Ulanowicz, R.E., 2004. Quantitative methods for ecological network analysis.
Comput. Biol. Chem. 28, 321-33

Ulanowicz, R.E., Holt, R.D., Barfield, M., 2014. Limits on ecosystem trophic
complexity: insights from ecological network analysis. Ecology Letters
17:127-136
}
\seealso{
\code{\link{read.scor},\link{read.wand},\link{enaStorage},\link{enaUtility}}
}
\author{
David E. Hines Matthew K. Lau Stuart R. Borrett
}
