% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emmGrid-methods.R
\name{update.emmGrid}
\alias{update.emmGrid}
\title{Update an \code{emmGrid} object}
\usage{
\method{update}{emmGrid}(object, ..., silent = FALSE)
}
\arguments{
\item{object}{An \code{emmGrid} object}

\item{...}{Options to be set. These must match a list of known options (see
Details)}

\item{silent}{Logical value. If \code{FALSE} (the default), a message is
displayed if any options are not matched. If \code{TRUE}, no messages are
shown.}
}
\value{
an updated \code{emmGrid} object.
}
\description{
Objects of class \code{emmGrid} contain several settings that affect such things as
what arguments to pass to \code{\link{summary.emmGrid}}. 
The \code{update} method allows safer management of these settings than
by direct modification of its slots.
}
\note{
When it makes sense, an option set by \code{update} will persist into 
future results based on that object. But some options are disabled as well.
For example, a \code{calc} option will be nulled-out if \code{contrast}
is called, because it probably will not make sense to do the same 
calculations on the contrast results, and in fact the variable(s) needed
may not even still exist.
}
\section{Details}{

The names in \code{\dots} are partially matched against those that are valid, and if a match is found, it adds or replaces the current setting. The valid names are

\describe{
\item{\code{tran}, \code{tran2}}{(\code{list} or \code{character}) specifies
the transformation which, when inverted, determines the results displayed by
\code{\link{summary.emmGrid}}, \code{\link{predict.emmGrid}}, or \code{\link{emmip}} when
\code{type="response"}. The value may be the name of a standard
transformation from \code{\link{make.link}} or additional ones supported by
name, such as \code{"log2"}; or, for a custom transformation, a \code{list}
containing at least the functions \code{linkinv} (the inverse of the
transformation) and \code{mu.eta} (the derivative thereof). The
\code{\link{make.tran}} function returns such lists for a number of popular
transformations. See the help page of \code{\link{make.tran}} for details as
well as information on the additional named transformations that are
supported. \code{tran2} is just like \code{tran} except it is a second
transformation (i.e., a response transformation in a generalized linear
model).}

\item{\code{tran.mult}}{Multiple for \code{tran}. For example, for the
response transformation \samp{2*sqrt(y)} (or \samp{sqrt(y) + sqrt(y + 1)},
for that matter), we should have \code{tran = "sqrt"} and \code{tran.mult =
2}. If absent, a multiple of 1 is assumed.}

\item{\code{tran.offset}}{Additive constant before a transformation is applied.
For example, a response transformation of \code{log(y + pi)} has
\code{tran.offset  = pi}. If no value is present, an offset of 0 is assumed.}

\item{\code{estName}}{(\code{character}) is the column label used for
displaying predictions or EMMs.}

\item{\code{inv.lbl}}{(\code{character)}) is the column label to use for
predictions or EMMs when \code{type="response"}.}

\item{\code{by.vars}}{(\code{character)} vector or \code{NULL}) the variables
used for grouping in the summary, and also for defining subfamilies in a call
to \code{\link{contrast}}.}

\item{\code{pri.vars}}{(\code{character} vector) are the names of the grid
variables that are not in \code{by.vars}. Thus, the combinations of their
levels are used as columns in each table produced by \code{\link{summary.emmGrid}}.}

\item{\code{alpha}}{(numeric) is the default significance level for tests, in
\code{\link{summary.emmGrid}} as well as \code{\link{plot.emmGrid}}
when \samp{CIs = TRUE}. Be cautious that methods that depend on
specifying \code{alpha} are prone to abuse. See the
discussion in \href{../doc/basics.html#pvalues}{\code{vignette("basics", "emmeans")}}.}

\item{\code{adjust}}{(\code{character)}) is the default for the \code{adjust}
argument in \code{\link{summary.emmGrid}}.}

\item{\code{famSize}}{(integer) is the number of means involved in a family of
inferences; used in Tukey adjustment}

\item{\code{infer}}{(\code{logical} vector of length 2) is the default value
of \code{infer} in \code{\link{summary.emmGrid}}.}

\item{\code{level}}{(numeric) is the default confidence level, \code{level},
in \code{\link{summary.emmGrid}}. \emph{Note:} You must specify all five letters 
of \sQuote{level} to distinguish it from the slot name \sQuote{levels}.}

\item{\code{df}}{(numeric) overrides the default degrees of freedom with a
specified single value.}

\item{\code{calc}}{(list) additional calculated columns. See \code{\link{summary.emmGrid}}.}

\item{\code{null}}{(numeric) null hypothesis for \code{summary} or
\code{test} (taken to be zero if missing).}

\item{\code{side}}{(numeric or character) \code{side} specification for for
\code{summary} or \code{test} (taken to be zero if missing).}

\item{\code{sigma}}{(numeric) Error SD to use in predictions and for bias-adjusted
back-transformations}

\item{\code{delta}}{(numeric) \code{delta} specification for \code{summary}
or \code{test} (taken to be zero if missing).}

\item{\code{predict.type} or \code{type}}{(character) sets the default method
of displaying predictions in \code{\link{summary.emmGrid}},
\code{\link{predict.emmGrid}}, and \code{\link{emmip}}. Valid values are
\code{"link"} (with synonyms \code{"lp"} and \code{"linear"}), or
\code{"response"}.}

\item{\code{bias.adjust}, \code{frequentist}}{(character) These
are used by \code{summary} if the value of these arguments are not specified.}

\item{\code{estType}}{(\code{character}) is used internally to determine 
what \code{adjust} methods are appropriate. It should match one of 
\samp{c("prediction", "contrast", "pairs")}. As an example of why this is needed,
the Tukey adjustment should only be used for pairwise comparisons 
(\code{estType = "pairs"}); if \code{estType} is some other string, Tukey
adjustments are not allowed.}

\item{\code{avgd.over}}{(\code{character)} vector) are the names of the 
variables whose levels are averaged over in obtaining marginal averages of 
predictions, i.e., estimated marginal means. Changing this might produce a 
misleading printout, but setting it to \code{character(0)} will suppress the 
\dQuote{averaged over} message in the summary.}

\item{\code{initMesg}}{(\code{character}) is a string that is added to the
beginning of any annotations that appear below the \code{\link{summary.emmGrid}}
display.}

\item{\code{methDesc}}{(\code{character}) is a string that may be used for
creating names for a list of \code{emmGrid} objects. }

\item{\code{nesting}}{(Character or named \code{list}) specifies the nesting
structure. See \dQuote{Recovering or overriding model information} in the
documentation for \code{\link{ref_grid}}. The current nesting structure is
displayed by \code{\link{str.emmGrid}}.}

\item{\code{levels}}{named \code{list} of new levels for the elements of the
current \code{emmGrid}. The list name(s) are used as new variable names, and
if needed, the list is expanded using \code{expand.grid}. These results replace
current variable names and levels. This specification changes the \code{levels}, 
\code{grid}, \code{roles}, and \code{misc} slots in the updated \code{emmGrid},
and resets \code{pri.vars}, \code{by.vars}, \code{adjust}, \code{famSize},
\code{avgd.over}, and \code{nesting}. 
\emph{Note:} All six letters of \code{levels} is needed in order to distinguish
it from \code{level}.}

\item{(any other slot name)}{If the name matches an element of
\code{slotNames(object)} other than \code{levels}, that slot is replaced by 
the supplied value, if it is of the required class (otherwise an error occurs). 

The user must be very careful in
replacing slots because they are interrelated; for example, the lengths
and dimensions of \code{grid}, \code{linfct}, \code{bhat}, and \code{V} must
conform.}
} %%%%%%% end \describe
}

\examples{
# Using an already-transformed response:
mypigs <- transform(pigs, logconc = log(pigs$conc))
mypigs.lm <- lm(logconc ~ source + factor(percent), data = mypigs)

# Reference grid that knows about the transformation
# and asks to include the sample size in any summaries:
mypigs.rg <- update(ref_grid(mypigs.lm), tran = "log", 
                    predict.type = "response",
                    calc = c(n = ~.wgt.))
emmeans(mypigs.rg, "source")
}
\seealso{
\code{\link{emm_options}}
}
