% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMC-support.R
\name{as.mcmc.emmGrid}
\alias{as.mcmc.emmGrid}
\alias{mcmc-support}
\alias{as.mcmc.list.emmGrid}
\title{Support for MCMC-based estimation}
\usage{
\method{as.mcmc}{emmGrid}(x, names = TRUE, sep.chains = TRUE, ...)

\method{as.mcmc.list}{emmGrid}(x, names = TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{emmGrid}}

\item{names}{Logical scalar or vector specifying whether variable names are
appended to levels in the column labels for the \code{as.mcmc} or
\code{as.mcmc.list} result -- e.g., column names of \code{treat A} and
\code{treat B} versus  just \code{A} and \code{B}. When there is more than
one variable involved, the elements of \code{names} are used cyclically.}

\item{sep.chains}{Logical value. If \code{TRUE}, and there is more than one
MCMC chain available, an \code{\link[coda]{mcmc.list}} object is returned
by \code{as.mcmc}, with separate EMMs posteriors in each chain.}

\item{...}{arguments passed to \code{\link[coda]{mcmc}}}
}
\value{
An object of class \code{\link[coda]{mcmc}} or \code{\link[coda]{mcmc.list}}.
}
\description{
When a model is fitted using Markov chain Monte Carlo (MCMC) methods, 
its reference grid contains a \code{post.beta} slot. These functions 
transform those posterior samples to posterior samples of EMMs or
related contrasts. They can then be summarized or plotted using,
e.g., functions in the \pkg{coda} package.
}
\section{Details}{

When the object's \code{post.beta} slot is non-trivial, \code{as.mcmc} will
return an \code{\link[coda]{mcmc}} or \code{\link[coda]{mcmc.list}} object
that can be summarized or plotted using methods in the \pkg{coda} package.
In these functions, \code{post.beta} is transformed by post-multiplying it by
\code{t(linfct)}, creating a sample from the posterior distribution of LS
means. In \code{as.mcmc}, if \code{sep.chains} is \code{TRUE} and there is in
fact more than one chain, an \code{mcmc.list} is returned with each chain's
results. The \code{as.mcmc.list} method is guaranteed to return an
\code{mcmc.list}, even if it comprises just one chain.
}

