% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.emm.R
\name{plot.emmGrid}
\alias{plot.emmGrid}
\alias{plot.summary_emm}
\title{Plot an \code{emmGrid} or \code{summary_emm} object}
\usage{
\method{plot}{emmGrid}(x, y, type, intervals = TRUE, comparisons = FALSE,
  alpha = 0.05, adjust = "tukey", int.adjust = "none", ...)

\method{plot}{summary_emm}(x, y, horizontal = TRUE, xlab, ylab, layout, ...)
}
\arguments{
\item{x}{Object of class \code{emmGrid} or \code{summary_emm}}

\item{y}{(Required but ignored)}

\item{type}{Character value specifying the type of prediction desired
(matching \code{"linear.predictor"}, \code{"link"}, or \code{"response"}).
See details under \code{\link{summary.emmGrid}}.}

\item{intervals}{Logical value. If \code{TRUE}, confidence intervals are
plotted for each estimate.}

\item{comparisons}{Logical value. If \code{TRUE}, \dQuote{comparison arrows}
are added to the plot, in such a way that the degree to which arrows
overlap reflects as much as possible the significance of the comparison of
the two estimates. (A warning is issued if this can't be done.)}

\item{alpha}{The significance level to use in constructing comparison arrows}

\item{adjust}{Character value: Multiplicity adjustment method for comparison arrows \emph{only}.}

\item{int.adjust}{Character value: Multiplicity adjustment method for the plotted confidence intervals \emph{only}.}

\item{...}{Additional arguments passed to \code{\link{update.emmGrid}} or
\code{\link[lattice]{dotplot}}}

\item{horizontal}{Logical value specifying whether the intervals should be
plotted horizontally or vertically}

\item{xlab}{Character label for horizontal axis}

\item{ylab}{Character label for vertical axis}

\item{layout}{Numeric value passed to \code{\link[lattice]{dotplot}}}
}
\description{
Methods are provided to plot EMMs as side-by-side intervals, and optionally to display 
  \dQuote{comparison arrows} for displaying pairwise comparisons.
}
\section{Details}{

If any \code{by} variables are in force, the plot is divided into separate
panels. These functions use the \code{\link[lattice]{dotplot}} function, and
thus require that the \pkg{lattice} package be installed. For
\code{"summary_emm"} objects, the \code{\dots} arguments in \code{plot}
are passed \emph{only} to \code{dotplot}, whereas for \code{"emmGrid"}
objects, the object is updated using \code{\dots} before summarizing and
plotting.

In plots with \code{comparisons = TRUE}, the resulting arrows are only
approximate, and in some cases may fail to accurately reflect the pairwise
comparisons of the estimates -- especially when estimates having large and
small standard errors are intermingled in just the wrong way. Note that the
maximum and minimum estimates have arrows only in one direction, since there
is no need to compare them with anything higher or lower, respectively.

If \code{adjust} or \code{int.adjust} are not supplied, they default to the 
internal \code{adjust} setting saved in \code{pairs(x)} and \code{x} 
respectively (see \code{\link{update.emmGrid}}).
}

\examples{
warp.lm <- lm(breaks ~ wool * tension, data = warpbreaks)
warp.emmGrid <- emmeans(warp.lm, ~ tension | wool)
plot(warp.emmGrid)
plot(warp.emmGrid, by = NULL, comparisons = TRUE, adjust = "mvt", 
     horizontal = FALSE)
}
