% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/roc-curve.r
\name{roc_curve}
\alias{as.data.frame.roc_curve}
\alias{as.data.table.roc_curve}
\alias{plot.roc_curve}
\alias{roc_curve}
\title{Calculate ROC curves}
\usage{
roc_curve(result, y, resample, class = levels(y), statistic = "probability")

\method{as.data.table}{roc_curve}(x, ...)

\method{as.data.frame}{roc_curve}(x, ...)

\method{plot}{roc_curve}(x, ...)
}
\arguments{
\item{result}{Modeling results, as returned by \code{\link{evaluate}}.}

\item{y}{True response vector used to create \code{result}.}

\item{resample}{Resampling scheme used to create \code{result}.}

\item{class}{The class of interest to create ROC-curves for.}

\item{statistic}{The name of the statistic (as returned by the prediction
function of the modeling procedure).}

\item{x}{Roc curve object, as returned by \code{roc_curve}.}

\item{...}{Sent to \code{\link{as.data.frame}} or \code{\link{as.data.table}}.}
}
\value{
A data frame of class \dQuote{roc}.
}
\description{
Calculate ROC curves
}
\examples{
# Generate some noisy data
my.data <- iris
my.data[1:4] <- my.data[1:4] + 2*rnorm(150*4)

# Train and evaluate some classifiers
procedure <- list(lda = modeling_procedure("lda"),
                  qda = modeling_procedure("qda"))
cv <- resample("crossvalidation", iris$Species, nrep=1, nfold=3)
result <- evaluate(procedure, my.data[-5], my.data$Species, resample=cv)

# Study the performance
select(result, fold=TRUE, method=TRUE, error="error")
roc <- roc_curve(result, my.data$Species, cv)
plot(roc)
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}

