% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/error-functions.r
\name{error_fun}
\alias{error_fun}
\alias{error_rate}
\alias{mse}
\alias{neg_auc}
\alias{neg_harrell_c}
\alias{rmse}
\title{Performance estimation functions}
\usage{
error_rate(truth, prediction, allow_rejection = !missing(rejection_cost),
  rejection_cost)

neg_auc(truth, prediction)

rmse(truth, prediction, na.rm = FALSE)

mse(truth, prediction, na.rm = FALSE)

neg_harrell_c(truth, prediction, na.rm = FALSE)
}
\arguments{
\item{truth}{The true response values, be it class labels, numeric values or
survival outcomes.}

\item{prediction}{A prediction object.}

\item{allow_rejection}{If \code{FALSE} missing prediction values will produce
an error. If \code{TRUE} missing values will be given a cost specified by
the \code{rejection_cost} argument.}

\item{rejection_cost}{See the argument \code{allow_rejection}. If missing a
rejection cost equivalent to the error rate obtained when assigning all
test observations to the most common class will be used.}

\item{na.rm}{Whether to remove missing values or not.}
}
\description{
These functions determine the performance of fitted model based on its
predictions. They are used both for evaluating whole modeling procedures and
to tune model parameters, i.e. find the parameter values with the best
performance.
The parameter tuning routine is designed to minimize its error function (or
optimization criteria), which is why functions that are to be maximized must
have their sign changed, like \code{neg_auc}.
}
\details{
Custom performance estimation functions should be implemented as follows:

\code{function(truth, prediction)}
\describe{
    \item{\code{truth}}{A vector of true responses.}
    \item{\code{prediction}}{Prediction returned from the prediction function.}
}

In most cases the true response and the predictions are of the same type,
e.g. true and fitted values in a regression or class labels in a
classification problem, but it is not a requirement. An example of different
types could be if the prediction function produce class probabilities for
all classes rather than one label, or the risks that the observations will
experience the event of interest, to be compared to the actual outcome that
it did occur or has not yet occurred at a specific time point.
See \code{\link{neg_harrell_c}} for an example of the latter.
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
\seealso{
\code{\link{emil}}, \code{\link{neg_gmpa}},
  \code{\link{modeling_procedure}}, \code{\link{extension}}
}

