% Generated by roxygen2 (4.0.1): do not edit by hand
\name{resample}
\alias{resample}
\alias{resample.crossval}
\alias{resample.holdout}
\title{Resampling schemes}
\usage{
resample(method, y, ..., subset)

resample.holdout(y = NULL, frac = 0.5, nfold = 5,
  balanced = is.factor(y), subset = TRUE)

resample.crossval(y, nfold = 5, nrep = 5, balanced = is.factor(y),
  subset = TRUE)
}
\arguments{
\item{method}{The resampling method to use, e.g. \code{"holdout"} or
\code{"crossval"}.}

\item{y}{Observations to be divided. Can either be supplied as the response
of the observations themselves, or as a scalar which is interpreted as the
number of objects.}

\item{...}{Sent to the method specific function, e.g.
\code{"resample.holdout"}.}

\item{nfold}{Number of folds.}

\item{balanced}{Whether the sets should be balanced or not, i.e. if the
class ratio over the sets should be kept constant (as far as possible).}

\item{subset}{Which objects in \code{y} that are to be divided and which
that are not to be part of neither set.
If \code{subset} is a resampling scheme, a list of inner
cross-validation schemes will be returned.}

\item{frac}{Fraction of objects to hold out (0 < frac < 1).}

\item{nrep}{Number of fold sets to generate.}
}
\value{
A data frame defining a resampling scheme. \code{TRUE} or a positive integer
  codes for training set and \code{FALSE} or \code{0} codes for test set.
  Positive integers > 1 code for multiple copies of an observation in the
  training set. \code{NA} codes for neither training nor test set and is
  used to exclude observations from the analysis altogether.
}
\description{
Performance evaluation and variable tuning use resampling methods to
estimate the performance of models. These are defined by resampling
schemes, which are data frames where each column corresponds to a
division of the data set into mutually exclusive training and test sets.
Repeated hold out and cross-validation are two methods to create such
schemes.
}
\details{
Note that when setting up analyzes, the user should not call
\code{resample.holdout} or \code{resample.crossval} directly, as
\code{resample} performs additional necessary processing of the scheme.

Resampling scheme can be visualized in a human digestible form with the
\code{\link[=image.resample]{image}} function.

Functions for generating custom resampling schemes should be implemented as
follows and then called by \code{resample("myMethod", ...)}:

\code{resample.myMethod <- function(y, ..., subset)}
\describe{
    \item{\code{y}}{Response vector.}
    \item{\code{...}}{Method specific attributes.}
    \item{\code{subset}}{Indexes of observations to be excluded for the
        resampling.}
}
The function should return a list of the following elements:
\describe{
    \item{\code{folds}}{A data frame with the folds of the scheme that
        conforms to the description in the 'Value' section below.}
    \item{\code{param}}{A list with the parameters necessary to generate
        such a resampling scheme. These are needed when creating subschemes
        needed for parameter tuning, see \code{\link{subresample}}.}
}
}
\examples{
resample("holdout", 50, frac=1/3)
resample("holdout", factor(runif(60) >= .5))
y <- factor(runif(60) >= .5)
cv <- resample("crossval", y)
image(cv, main="Cross-validation scheme")
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
\seealso{
\code{\link{emil}}, \code{\link{subresample}},
  \code{\link{image.resample}}, \code{\link{index.fit}}
}

