% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DatabaseTSD.R
\docType{data}
\encoding{UTF-8}
\name{DatabaseTSD}
\alias{DatabaseTSD}
\title{Database of TSD information for reptiles}
\format{A dataframe with raw data.}
\usage{
DatabaseTSD
}
\description{
Database of TSD information for reptiles\cr
The columns are:\cr
* Species: Name de the species in binominal nommenclature\cr
* Country: From which country the eggs come from\cr
* Area: Name of the beach or region the eggs come from\cr
* RMU: For marine turtles, name of the RMU for this population; see Wallace, B.P., DiMatteo, A.D., Hurley, B.J., Finkbeiner, E.M., Bolten, A.B., Chaloupka, M.Y., Hutchinson, B.J., Abreu-Grobois, F.A., Amorocho, D., Bjorndal, K.A., Bourjea, J., Bowen, B.W., Duenas, R.B., Casale, P., Choudhury, B.C., Costa, A., Dutton, P.H., Fallabrino, A., Girard, A., Girondot, M., Godfrey, M.H., Hamann, M., Lopez-Mendilaharsu, M., Marcovaldi, M.A., Mortimer, J.A., Musick, J.A., Nel, R., Seminoff, J.A., Troeng, S., Witherington, B., Mast, R.B., 2010. Regional management units for marine turtles: a novel framework for prioritizing conservation and research across multiple scales. Plos One 5, e15465.\cr
* Incubation.temperature: Nominal incubation temperature\cr
* Incubation.temperature.Accuracy: What is the accuracy of the measure of temperature\cr
* Incubation.temperature.SD: Experimental SD of incubation temperatures\cr
* Incubation.temperature.Amplitude: How much the temperature could fluctuate around nominal temperature\cr
* Correction.factor: Difference between the incubator temperature and the eggs temperature\cr
* IP.min: Shorter incubation period\cr
* IP.max: Longer incubation period\cr
* IP.mean: Mean incubation periods\cr
* IP.SD: Standard deviation for incubation periods\cr
* Total: Total number of eggs incubated\cr
* Hatched: Number of hatchlings\cr
* NotHatched: Number of embryos with development visible but dead during incubation\cr
* Undeveloped: Number of embryos showing no development\cr
* Intersexes: Number of individuals intersexes or ambiguous for sex phenotype\cr
* Males: Number of individuals indentified as males\cr
* Females: Number of individuals indentified as females\cr
* Sexed: Number of sexed individuals\cr
* Clutch: Identity of clutch\cr
* Reference: Bibliographic reference\cr
* Note: Diverse information for this incubation\cr
* Version: Date of the version of this database\cr
Initial version of this database has been built by Maria Sousa Martins.
}
\details{
Database of TSD information for marine turtles
}
\examples{
\dontrun{
library(embryogrowth)
data(DatabaseTSD)
DatabaseTSD$Version[1]
totalIncubation_Lo <- subset(DatabaseTSD, 
         Species=="Lepidochelys olivacea" & (!is.na(Sexed) & Sexed!=0), 
         select=c("Males", "Females", "Incubation.temperature"))
tot_Lo <- with(totalIncubation_Lo, tsd(males=Males, females=Females, 
 temperatures=Incubation.temperature), parameters.initial = c(P=30.5, S=-0.4))
 predict(tot_Lo)
}
}
\references{
Binckley C.A., Spotila J.R., Wilson K.S. and Paladino F.V. (1998) Sex determination and sex ratios of Pacific Leatherback Turtles, Dermochelys coriacea. Copeia, 1998(2), 291-300.

Castheloge, V.D., de D. dos Santos, M.R., de Castilhos, J.C., de J. Filho, P.R., de C. Gomes, L., Clemente-Carvalho, R.B.G., Ferreira, P.D., 2018. Pivotal temperature and hatcHling sex ratio of olive ridley sea turtles Lepidochelys olivacea from the South Atlantic coast of Brazil. Herpetological Conservation and Biology 13, 488-496.

Crastz F. (1982) Embryological stages of the marine turtle Lepidochelys olivacea (Eschscholtz). Rev. Biol. Trop., 30, 113-120.

De Souza, R.R., Vogt, R.C., 1994. Incubation temperature influences sex and hatchling size in the neotropical turtle Podocnemis unifilis. Journal of Herpetology 28, 453-464.

Dimond, M.T., 1985. Some effects of temperature on turtle egg incubation, in: Goel, S.C., Srivastava, C.B.L. (Eds.), Recent Advances in Developmental Biology of Animals. Indian Society of Developmental Biologists, Poona, India, pp. 35-39.

Emer, S.A., 2007. Temperature-dependent sex determination in Manouria emys emys, the asian forest tortoise, College of Arts and Sciences. Georgia State University, Atlanta, GE, p. 60.

Georges A., Limpus C.J. and Stoutjesdijk R. (1994) Hatchling sex in the marine turtle Caretta caretta is determined by proportion of development at a temperature, not daily duration of exposure. Journal of Experimental Zoology, 270(5), 432-444.

Girondot M. 1999 Statistical description of temperature-dependent sex determination using maximum likelihood. Evolutionary Ecology Research, 1(3), 479-486.

Gu, H.-X., Xia, Z.-R., Li, P.-P., Duan, J.-X., Ye, M.-B., Zhang, F.-Y., Chen, H.-L., Lin, R.-J., 2010. Sex identification and pivotal temperature for sex determination in hatchling green sea turtle. Chinese J. Zool. 45, 81-88.

Gutzke, W. H. N., & Paukstis, G. L. (1983). Influence of the hydric environment on sexual differentiation in turtles. J. Exp. Zool., 226, 467-469. [Chrysemys picta]

Harry, J.L., Limpus, C.J., 1989. Low temperature protection of marine turtle eggs during long-distance relocation. Aust. Wildl. Res. 16.

Hernández-Montoya V, Páez VP, Ceballos CP (2017) Effects of temperature on sex determination and embryonic development in the red-footed tortoise, Chelonoidis carbonarius. Chelonian Conservation and Biology 16:164-171

Hewavisenthi, S. (1999) Influence of incubation environment on the development of the flatback turtle (Natator depressus). Ph.D. Thesis, Central Queensland University.

Hewavisenthi, S. & Parmenter, C.J. (2000) Hydric environment and sex determination in the flatback turtle (Natator depressus Garman) (Chelonia : Cheloniidae). Australian Journal of Zoology, 48, 653-659.

Hulin, V., Delmas, V., Girondot, M., Godfrey, M. H. and Guillon, J.-M. 2009. Temperature-dependent sex determination and global change: are some species at greater risk? Oecologia, 160, 493-506.

LeBlanc, A.M., Wibbels, T., Shaver, D., Walker, J.S., 2012. Temperature-dependent sex determination in the Kemp’s ridley sea turtle: effects of incubation temperatures on sex ratios. Endangered Species Research 19, 123-128.

Limpus C.J., Reed P.C. and Miller J.D. (1985) Temperature dependent sex determination in Queensland sea turtles: Intraspecific variation in Caretta caretta. In Grigg G., Shine R. and Ehmann H. (eds) Biology of Australian frogs and reptiles. New South Wales, Australia: Royal Zoological Society, pp 343-351.

Limpus C.J., Reed P. and Miller J.D. (1983) Islands and turtles: the influence of choice of nesting beach on sex ratio. In Baker J.J., Carter R.M., Saurmarco P.W. and Stark K.P. (eds.) Proceedings of the Inaugural Great Barrier Reef Conference, 29 August-2 September, 1983. James Cook University Press of North Queensland, pp. 397-402.

López Correa, J.Y., 2010. Diferenciacion gonadica en crias de Lepidochelys olivacea (Eschscholtz, 1829) (Testudinata: Cheloniidae), Instituto Politicnico Nacional, Centro Interdisciplinaria de Ciencias Marinas, La Paz, BCS, p. 108.

Lubiana, A.l., Júnior, P.D.F., 2009. Pivotal temperature and sexual dimorphism of Podocnemis expansa hatchlings (Testudines: Podocnemididae) from Bananal Island, Brazil. Zoologia 26, 527-533.

Marcovaldi M.A., Godfrey M.H. and Mrosovsky N. (1997) Estimating sex ratios of loggerhead turtles in Brazil from pivotal incubation temperatures. Canadian Journal of Zoology-Revue Canadienne De Zoologie, 75, 755-770.

McCoy C.J., Vogt R.C. and Censky E.J. (1983) Temperature-controlled sex determination in the sea turtle Lepidochelys olivacea. J. Herpetol., 17(4), 404-406.

Merchant-Larios, H, Diaz-Hernandez, V, Marmolejo-Valencia A. 2010. Gonadal morphogenesis and gene expression in reptiles with temperature-dependent sex determination. Sexual Development 4:50-61.

Merchant-Larios, H., Villalpando-Fierro, I. & Centeno-Urruiza, B. 1989. Gonadal morphogenesis under controlled temperature in the sea turtle Lepidochelys olivacea. Herpetol. Monographs, 3, 43-61.

Merchant-Larios, H., Ruiz-Ramirez, S., Moreno-Mendoza, N. & Marmolejo-Valencia, A. 1997. Correlation among thermosensitive period, estradiol response, and gonad differentiation in the sea turtle Lepidochelys olivacea. General and Comparative Endocrinology, 107, 373-385.

Michel-Morfinu J.E., Gomez Munoz V.M. and Navarro Rodriguez C. (2001) Morphometric model for sex assessment in hatchling olive ridley sea turtles. Chelonian Conservation and Biology, 40(1), 53-58.

Mohanty-Hejmadi, P., Behra, M., Dimond, M.T., 1985. Temperature dependent sex differentiation in the olive ridley Lepidochelys olivacea and its implications for conservation, Symposium on Endangered Marine Animals and Marine Parks. Marine Biological Association of India, Cochin., pp. 1-5.

Mrosovsky N., Kamel S., Rees A.F. and Margaritoulis D. (2002) Pivotal temperature for loggerhead turtles (Caretta caretta) from Kyparissia Bay, Greece. Canadian Journal of Zoology-Revue Canadienne De Zoologie, 80(12), 2118-2124.

Mrosovsky N., Dutton P.H. and Whitmore C.P. (1984) Sex ratios of two species of sea turtle nesting in Suriname. Can. J. Zool., 62, 2227-2239.

Mrosovsky N., Bass A., Corliss L.A., Richardson J.I. and Richardson T.H. (1992) Pivotal and beach temperature for hawksbill turtles nesting in Antigua. Can. J. Zool., 70, 1920-1925.

Rimblot F., Fretey J., Mrosovsky N., Lescure J. and Pieau C. (1985) Sexual differentiation as a function of the incubation temperature of eggs in the sea-turtle Dermochelys coriacea (Vandelli, 1761). Amphibia-Reptilia, 85(6), 83-92.

Rimblot-Baly F., Lescure J., Fretey J. and Pieau C. (1986-1987) Sensibilité à la température de la differenciation sexuelle chez la tortue Luth, Dermochelys coriacea (Vandelli, 1761); application des données de l'incubation artificielle à l'étude de la sex-ratio dans la nature. Annales des Sciences Naturelles, Zoologie, 8, 277-290.

Ruiz Garcia N.A. (2014) Efectos de la temperatura sobre el desarrollo embrionario y el desempeño de crías de la tortuga golfina, Lepidochelys olivacea. Tesis Nivel Maestria.

Shaver, D.J., 2007. Padre Island National Seashore, Texas sea turtle nesting and stranding 2006 report. U.S. Department of the Interior, National Park Service Publication, p. 30.

Shaver, D.J., 2008. Padre Island National Seashore, Texas sea turtle nesting and stranding 2007 report. U.S. Department of the Interior, National Park Service Publication, p. 33.

Shaver, D.J., 2009. Padre Island National Seashore, Texas sea turtle nesting and stranding 2008 report. U.S. Department of the Interior, National Park Service Publication, p. 38.

Shaver, D.J., Owens, D.W., Chaney, A.H., Caillouet, C.W., Burchfield Jr., P., Marquez, R., 1988. Styrofoam box and beach temperatures in relation to incubation and sex ratios of kemp's ridley sea turtles, in: Schroeder, B.A. (Ed.), Proceedings of the Eighth Annual Workshop on Sea Turtle Conservation and Biology. NOAA Technical Memorandum NMFS-SEFC-214, Fort Fisher, North Carolina, USA, pp. 103-108.

Valenzuela, N., 2001. Constant, shift, and natural temperature effects on sex determination in Podocnemis expansa. Ecology 82, 3010-3024.

Tokunaga, S., Iwakiri, Y., Nakajima, Y., (1999). Temperature-dependent sex determination of a sea turtle, Caretta caretta, from Miyazaki,Japan. Bull. Kitakyushu Mus. Nat. Hist. 18, 147-156.

Wibbels T., Rostal D.C. and Byles R. (1998) High pivotal temperature in the sex determination of the olive ridley sea turtle, Lepidochelys olivacea, from Playa Nancite, Costa Rica. Copeia, 1998(4), 1086-1088.

Yntema C.L. and Mrosovsky N. (1980) Sexual differentiation in hatchling loggerheads (Caretta caretta) incubated at different controlled temperatures. Herpetologica, 36(1), 33-36.

Yntema C.L. and Mrosovsky N. (1982) Critical periods and pivotal temperatures for sexual differentiation in loggerhead sea turtles. Canadian Journal of Zoology-Revue Canadienne De Zoologie, 60(5), 1012-1016.
}
\seealso{
Other Functions for temperature-dependent sex determination: \code{\link{P_TRT}},
  \code{\link{TSP.list}}, \code{\link{plot.tsd}},
  \code{\link{predict.tsd}}, \code{\link{stages}},
  \code{\link{tsd_MHmcmc_p}}, \code{\link{tsd_MHmcmc}},
  \code{\link{tsd}}
}
\author{
Marc Girondot \email{marc.girondot@u-psud.fr}
}
\concept{Functions for temperature-dependent sex determination}
\keyword{datasets}
