% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsd_MHmcmc.R
\name{tsd_MHmcmc}
\alias{tsd_MHmcmc}
\title{Metropolis-Hastings algorithm for Sex ratio}
\usage{
tsd_MHmcmc(result = stop("A result of tsd() fit must be provided"),
  n.iter = 10000, parametersMCMC = NULL, n.chains = 1, n.adapt = 0,
  thin = 1, trace = FALSE, batchSize = sqrt(n.iter),
  intermediate = NULL, filename = "intermediate.Rdata", previous = NULL)
}
\arguments{
\item{result}{An object obtained after a SearchR fit}

\item{n.iter}{Number of iterations for each step}

\item{parametersMCMC}{A set of parameters used as initial point for searching with information on priors}

\item{n.chains}{Number of replicates}

\item{n.adapt}{Number of iterations before to store outputs}

\item{thin}{Number of iterations between each stored output}

\item{trace}{True or False, shows progress}

\item{batchSize}{Number of observations to include in each batch fo SE estimation}

\item{intermediate}{Period for saving intermediate result, NULL for no save}

\item{filename}{If intermediate is not NULL, save intermediate result in this file}

\item{previous}{Previous result to be continued. Can be the filename in which intermediate results are saved.}
}
\value{
A list with resultMCMC being mcmc.list object, resultLnL being likelihoods and parametersMCMC being the parameters used
}
\description{
Run the Metropolis-Hastings algorithm for tsd.\cr
Deeply modified from a MCMC script by Olivier Martin (INRA, Paris-Grignon).\cr
The number of iterations is n.iter+n.adapt+1 because the initial likelihood is also displayed.\cr
I recommend that thin=1 because the method to estimate SE uses resampling.\cr
If initial point is maximum likelihood, n.adapt = 0 is a good solution.\cr
To get the SE from result_mcmc <- tsd_MHmcmc(result=try), use:\cr
result_mcmc$BatchSE or result_mcmc$TimeSeriesSE\cr
The batch standard error procedure is usually thought to be not as accurate as the time series methods.\cr
Based on Jones, Haran, Caffo and Neath (2005), the batch size should be equal to sqrt(n.iter).\cr
Jones, G.L., Haran, M., Caffo, B.S. and Neath, R. (2006) Fixed Width Output Analysis for Markov chain Monte Carlo , Journal of the American Statistical Association, 101:1537-1547.\cr
coda package is necessary for this function.\cr
#' The parameters intermediate and filename are used to save intermediate results every 'intermediate' iterations (for example 1000). Results are saved in a file of name filename.\cr
The parameter previous is used to indicate the list that has been save using the parameters intermediate and filename. It permits to continue a mcmc search.\cr
These options are used to prevent the consequences of computer crash or if the run is very very long and processes at time limited.\cr
}
\details{
tsd_MHmcmc runs the Metropolis-Hastings algorithm for tsd (Bayesian MCMC)
}
\examples{
\dontrun{
library(embryogrowth)
eo <- subset(DatabaseTSD, Species=="Emys orbicularis", c("Males", "Females", 
                                       "Incubation.temperature"))
eo_logistic <- tsd(eo)
pMCMC <- tsd_MHmcmc_p(eo_logistic, accept=TRUE)
# Take care, it can be very long; several days
result_mcmc_tsd <- tsd_MHmcmc(result=eo_logistic, 
		parametersMCMC=pMCMC, n.iter=10000, n.chains = 1,  
		n.adapt = 0, thin=1, trace=TRUE)
# summary() permits to get rapidly the standard errors for parameters
summary(result_mcmc_tsd)
# They are store in the result also. Two SE are estimated using or 
# batch method or time-series SE:
# The batch standard error procedure is usually thought to be not 
# as accurate as the time series methods.
se1 <- result_mcmc_tsd$BatchSE
se2 <- result_mcmc_tsd$TimeSeriesSE
plot(result_mcmc_tsd, parameters="S", scale.prior=TRUE, xlim=c(-3, 3), las=1)
plot(result_mcmc_tsd, parameters="P", scale.prior=TRUE, xlim=c(25, 35), las=1)
plot(eo_logistic, se=se2)
}
}
\author{
Marc Girondot
}
\seealso{
Other Functions.for.temperature.dependent.sex.determination: \code{\link{DatabaseTSD}},
  \code{\link{TSP.list}}, \code{\link{predict.tsd}},
  \code{\link{stages}}, \code{\link{tsd_MHmcmc_p}},
  \code{\link{tsd}}
}

