% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/TSP.list.R
\docType{data}
\name{TSP.list}
\alias{TSP.list}
\title{Database of thermosensitive period of development for sex determination}
\format{A list with dataframes including attributes}
\usage{
TSP.list
}
\description{
Database of thermosensitive period of development for sex determination
}
\details{
Database of thermosensitive period of development for sex determination
}
\examples{
\dontrun{
library(embryogrowth)
data(TSP.list)
names(TSP.list)
TSP.list[["Emys_orbicularis.mass"]]
attributes(TSP.list[["Emys_orbicularis.mass"]])$TSP.begin.stages
attributes(TSP.list[["Emys_orbicularis.mass"]])$TSP.end.stages
}
}
\author{
Marc Girondot \email{marc.girondot@u-psud.fr}
}
\references{
Pieau, C., Dorizzi, M., 1981. Determination of temperature sensitive
stages for sexual differentiation of the gonads in embryos of the turtle,
Emys orbicularis. Journal of Morphology 170, 373-382.
Yntema, C.L., Mrosovsky, N., 1982. Critical periods and pivotal temperatures for
sexual differentiation in loggerhead sea turtles. Canadian Journal of
Zoology-Revue Canadienne de Zoologie 60, 1012-1016.
}
\seealso{
Other Functions.for.temperature.dependent.sex.determination: \code{\link{STSRE_TSD}};
  \code{\link{predict.tsd}}; \code{\link{tsd_MHmcmc_p}};
  \code{\link{tsd_MHmcmc}}; \code{\link{tsd}}
}
\keyword{datasets}

