% Generated by roxygen2 (4.0.1): do not edit by hand
\name{MovingIncubation}
\alias{MovingIncubation}
\title{Simulate incubation of a nest with the beginning of incubation varying}
\usage{

  MovingIncubation(result = stop("A result file from searchR() must be provided"),
  temperatures = stop("A timeseries of temperature must be provided"),
  times = stop("A timeseries of time for each temperature must be provided"),
  temperatures.end.incubation = temperatures,
  average.incubation.duration = 60 * 1440, skip = 1, parameters = NULL,
  fixed.parameters = NULL, SE = NULL, derivate = NULL, test = NULL,
  M0 = NULL, TSP.borders = c(21, 26), embryo.stages = "Caretta caretta",
  replicate.CI = 1, min.length = 40 * 1440, max.length = 150 * 1440,
  progress = TRUE)
}
\arguments{
\item{result}{A result file generated by searchR}

\item{times}{Timeseries of times}

\item{temperatures}{Timeseries of temperatures}

\item{temperatures.end.incubation}{Timeseries of temperatures at the end of incubation}

\item{average.incubation.duration}{The average time to complete incubation}

\item{skip}{Number of data to skip between two runs}

\item{min.length}{Minimum length of possible incubation}

\item{max.length}{Maximum length of possible incubation}

\item{parameters}{A set of parameters if result is not provided.}

\item{fixed.parameters}{Another set of parameters if result is not provided.}

\item{SE}{Standard error for each parameter if not present in result is not provided (not used still)}

\item{derivate}{Function used to fit embryo growth: dydt.Gompertz, dydt.exponential or dydt.linear}

\item{test}{Mean and SD of size of hatchlings as a vector ie test=c(Mean=xx, SD=yy)}

\item{M0}{Measure of hatchling size proxi at laying date}

\item{TSP.borders}{The limits of TSP}

\item{embryo.stages}{The embryo stages. At least TSP.borders stages must be provided to estimate TSP length}

\item{replicate.CI}{Number of randomizations to estimate CI (not used still)}

\item{progress}{If TRUE, progression bar is shown (desactivate for sweave or knitr)}
}
\value{
A dataframe with informations about thermosensitive period length and incubation length day by day of incubation
}
\description{
Simulate incubation of a nest with the beginning varying day by day\cr
Temperatures must be in a data.frame with one column (Time) being the time and the second the temperatures (Temperatures). Do not use FormatNests() for this dataframe.
}
\details{
MovingIncubation simulate incubation of a nest with the beginning varying day by day
}
\examples{
\dontrun{
library(embryogrowth)
data(resultNest_4p)
ti <- seq(from=0, to=(60*24*100), by=60)
temp <- rnorm(length(ti), 29, 5)
out <- MovingIncubation(result=resultNest_4p, temperatures=temp,
times=ti)
}
}
\author{
Marc Girondot
}

