% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HatchingSuccess.MHmcmc.R
\name{HatchingSuccess.MHmcmc}
\alias{HatchingSuccess.MHmcmc}
\title{Metropolis-Hastings algorithm for hatching success}
\usage{
HatchingSuccess.MHmcmc(
  result = stop("Give a result of HatchingSuccess.fit()"),
  n.iter = 10000,
  parametersMCMC = NULL,
  n.chains = 1,
  n.adapt = 0,
  thin = 1,
  trace = FALSE,
  traceML = FALSE,
  batchSize = sqrt(n.iter),
  adaptive = FALSE,
  adaptive.lag = 500,
  adaptive.fun = function(x) {
     ifelse(x > 0.234, 1.3, 0.7)
 },
  intermediate = NULL,
  filename = "intermediate.Rdata",
  previous = NULL
)
}
\arguments{
\item{result}{An object obtained after a SearchR fit}

\item{n.iter}{Number of iterations for each step}

\item{parametersMCMC}{A set of parameters used as initial point for searching with information on priors}

\item{n.chains}{Number of replicates}

\item{n.adapt}{Number of iterations before to store outputs}

\item{thin}{Number of iterations between each stored output}

\item{trace}{TRUE or FALSE or period, shows progress}

\item{traceML}{TRUE or FALSE to show ML}

\item{batchSize}{Number of observations to include in each batch fo SE estimation}

\item{adaptive}{Should an adaptive process for SDProp be used}

\item{adaptive.lag}{Lag to analyze the SDProp value in an adaptive content}

\item{adaptive.fun}{Function used to change the SDProp}

\item{intermediate}{Period for saving intermediate result, NULL for no save}

\item{filename}{If intermediate is not NULL, save intermediate result in this file}

\item{previous}{Previous result to be continued. Can be the filename in which intermediate results are saved.}
}
\value{
A list with resultMCMC being mcmc.list object, resultLnL being likelihoods and parametersMCMC being the parameters used
}
\description{
Run the Metropolis-Hastings algorithm for hatching success.\cr
The number of iterations is n.iter+n.adapt+1 because the initial likelihood is also displayed.\cr
I recommend that thin=1 because the method to estimate SE uses resampling.\cr
If initial point is maximum likelihood, n.adapt = 0 is a good solution.\cr
To get the SE from result_mcmc <- HatchingSuccess.MHmcmc(result=try), use:\cr
result_mcmc$BatchSE or result_mcmc$TimeSeriesSE\cr
The batch standard error procedure is usually thought to be not as accurate as the time series methods.\cr
Based on Jones, Haran, Caffo and Neath (2005), the batch size should be equal to sqrt(n.iter).\cr
Jones, G.L., Haran, M., Caffo, B.S. and Neath, R. (2006) Fixed Width Output Analysis for Markov chain Monte Carlo , Journal of the American Statistical Association, 101:1537-1547.\cr
coda package is necessary for this function.\cr
The parameters intermediate and filename are used to save intermediate results every 'intermediate' iterations (for example 1000). Results are saved in a file of name filename.\cr
The parameter previous is used to indicate the list that has been save using the parameters intermediate and filename. It permits to continue a mcmc search.\cr
These options are used to prevent the consequences of computer crash or if the run is very very long and processes at time limited.\cr
}
\details{
HatchingSuccess.MHmcmc runs the Metropolis-Hastings algorithm for hatching success (Bayesian MCMC)
}
\examples{
\dontrun{
library(embryogrowth)
totalIncubation_Cc <- subset(DatabaseTSD, 
                             Species=="Caretta caretta" & 
                               Note != "Sinusoidal pattern" & 
                               !is.na(Total) & Total != 0)

par <- c(S.low=0.5, S.high=0.3, 
         P.low=25, deltaP=10, MaxHS=0.8)
         
g <- HatchingSuccess.fit(par=par, data=totalIncubation_Cc)
pMCMC <- HatchingSuccess.MHmcmc_p(g, accept=TRUE)
mcmc <- HatchingSuccess.MHmcmc(result=g, parameters = pMCMC, 
                  adaptive=TRUE, n.iter=100000, trace=1000)
}
}
\seealso{
Other Hatching success: 
\code{\link{HatchingSuccess.MHmcmc_p}()},
\code{\link{HatchingSuccess.fit}()},
\code{\link{HatchingSuccess.lnL}()},
\code{\link{HatchingSuccess.model}()},
\code{\link{logLik.HatchingSuccess}()},
\code{\link{nobs.HatchingSuccess}()},
\code{\link{predict.HatchingSuccess}()}
}
\author{
Marc Girondot
}
\concept{Hatching success}
