% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff.R
\name{get_models_based_on_mcc_class_id}
\alias{get_models_based_on_mcc_class_id}
\title{Get models based on the MCC class id}
\usage{
get_models_based_on_mcc_class_id(class.id, models.cluster.ids, models.mcc)
}
\arguments{
\item{class.id}{an integer specifying the class id.}

\item{models.cluster.ids}{a numeric vector of cluster ids assigned to each
model. It is the result of using \code{\link[Ckmeans.1d.dp]{Ckmeans.1d.dp}}
with input the sorted vector of the models' MCC values with no NaNs included.}

\item{models.mcc}{a numeric sorted vector of Matthews Correlation Coefficient (MCC)
scores, one for each model (no NaNs included).
The \emph{names} attribute holds the models' names.}
}
\value{
a character vector of model names
}
\description{
This helper function finds all the models that belong to a specific MCC
cluster, i.e. their MCC values belong to the same cluster id.
}
