% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elo.model.frame.R
\name{elo.model.frame}
\alias{elo.model.frame}
\title{Interpret formulas in \code{elo} functions}
\usage{
elo.model.frame(
  formula,
  data,
  na.action,
  subset,
  k = NULL,
  ...,
  required.vars = "elos",
  warn.k = TRUE,
  ncol.k = 1,
  ncol.elos = 2
)
}
\arguments{
\item{formula}{A formula. See \link[=formula.specials]{the help page for formulas} for details.}

\item{data}{A \code{data.frame} in which to look for objects in \code{formula}.}

\item{na.action}{A function which indicates what should happen when the data contain NAs.}

\item{subset}{An optional vector specifying a subset of observations.}

\item{k}{A constant k-value (or a vector, where appropriate).}

\item{...}{Other arguments (not in use at this time).}

\item{required.vars}{One or more of \code{c("wins", "elos", "k", "group", "regress")},
denoting which variables are required to appear in the final model.frame.}

\item{warn.k}{Should a warning be issued if \code{k} is specified as an argument and in \code{formula}?}

\item{ncol.k}{How many columns (\code{NCOL}) should \code{k} have?}

\item{ncol.elos}{How many Elo columns are expected?}
}
\description{
A helper function to create the \code{model.frame} for many \code{elo} functions.
}
\seealso{
\code{\link{elo.run}}, \code{\link{elo.calc}}, \code{\link{elo.update}}, \code{\link{elo.prob}}
}
