% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elo.run.R
\name{elo.run}
\alias{elo.run}
\alias{print.elo.run}
\alias{print.elo.run.regressed}
\title{\code{elo.run}}
\usage{
elo.run(formula, data, na.action, subset, k = NULL,
  initial.elos = NULL, ...)

\method{print}{elo.run}(x, ...)

\method{print}{elo.run.regressed}(x, ...)
}
\arguments{
\item{formula}{A formula. See \link[=formula.specials]{the help page for formulas} for details.}

\item{data}{A \code{data.frame} in which to look for objects in \code{formula}.}

\item{na.action}{A function which indicates what should happen when the data contain NAs.}

\item{subset}{An optional vector specifying a subset of observations.}

\item{k}{A constant k-value (or a vector, where appropriate).}

\item{initial.elos}{An optional named vector containing initial Elo ratings for all teams in \code{formula}.}

\item{...}{Other arguments (not used at this time).}

\item{x}{An object of class \code{"elo.run"} or class \code{"elo.run.regressed"}.}
}
\value{
An object of class \code{"elo.run"} or class \code{"elo.run.regressed"}.
}
\description{
Calculate Elos for a series of matches.
}
\examples{
data(tournament)
elo.run(score(points.Home, points.Visitor) ~ team.Home + team.Visitor,
        data = tournament, k = 20)

# Create non-constant 'k'
elo.run(score(points.Home, points.Visitor) ~ team.Home + team.Visitor +
        k(20*log(abs(points.Home - points.Visitor) + 1)), data = tournament)

# Adjust Elo for, e.g., home-field advantage
elo.run(score(points.Home, points.Visitor) ~ adjust(team.Home, 30) + team.Visitor,
        data = tournament, k = 20)

tournament$home.field <- 30
elo.run(score(points.Home, points.Visitor) ~ adjust(team.Home, home.field) + team.Visitor,
        data = tournament, k = 20)

# Regress the Elos back toward 1500 at the end of the half-season
elo.run(score(points.Home, points.Visitor) ~ adjust(team.Home, 30) +
        team.Visitor + regress(half, 1500, 0.2), data = tournament, k = 20)

}
\seealso{
\code{\link{score}}, \link{elo.run.helpers}{elo.run helpers}, \code{\link{elo.calc}},
  \code{\link{elo.update}}, \code{\link{elo.prob}}, \code{\link{elo.model.frame}}.
}
