% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chat-parallel.R
\name{parallel_chat}
\alias{parallel_chat}
\alias{parallel_chat_structured}
\title{Submit multiple chats in parallel}
\usage{
parallel_chat(chat, prompts, max_active = 10, rpm = 500)

parallel_chat_structured(
  chat,
  prompts,
  type,
  convert = TRUE,
  include_tokens = FALSE,
  include_cost = FALSE,
  max_active = 10,
  rpm = 500
)
}
\arguments{
\item{chat}{A base chat object.}

\item{prompts}{A vector created by \code{\link[=interpolate]{interpolate()}} or a list
of character vectors.}

\item{max_active}{The maximum number of simultaneous requests to send.

For \code{\link[=chat_anthropic]{chat_anthropic()}}, note that the number of active connections is
limited primarily by the output tokens per minute limit (OTPM) which is
estimated from the \code{max_tokens} parameter, which defaults to 4096. That
means if your usage tier limits you to 16,000 OTPM, you should either set
\code{max_active = 4} (16,000 / 4096) to decrease the number of active
connections or use \code{\link[=params]{params()}} in \code{chat_anthropic()} to decrease
\code{max_tokens}.}

\item{rpm}{Maximum number of requests per minute.}

\item{type}{A type specification for the extracted data. Should be
created with a \code{\link[=type_boolean]{type_()}} function.}

\item{convert}{If \code{TRUE}, automatically convert from JSON lists to R
data types using the schema. This typically works best when \code{type} is
\code{\link[=type_object]{type_object()}} as this will give you a data frame with one column for
each property. If \code{FALSE}, returns a list.}

\item{include_tokens}{If \code{TRUE}, and the result is a data frame, will
add \code{input_tokens} and \code{output_tokens} columns giving the total input
and output tokens for each prompt.}

\item{include_cost}{If \code{TRUE}, and the result is a data frame, will
add \code{cost} column giving the cost of each prompt.}
}
\value{
For \code{parallel_chat()}, a list of \link{Chat} objects, one for each prompt.
For \code{parallel_chat_structured()}, a single structured data object with one
element for each prompt. Typically, when \code{type} is an object, this will
will be a data frame with one row for each prompt, and one column for each
property.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

If you have multiple prompts, you can submit them in parallel. This is
typically considerably faster than submitting them in sequence, especially
with Gemini and OpenAI.

If you're using \code{\link[=chat_openai]{chat_openai()}} or \code{\link[=chat_anthropic]{chat_anthropic()}} and you're willing
to wait longer, you might want to use \code{\link[=batch_chat]{batch_chat()}} instead, as it comes
with a 50\% discount in return for taking up to 24 hours.
}
\examples{
\dontshow{if (ellmer::has_credentials("openai")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
chat <- chat_openai()

# Chat ----------------------------------------------------------------------
country <- c("Canada", "New Zealand", "Jamaica", "United States")
prompts <- interpolate("What's the capital of {{country}}?")
parallel_chat(chat, prompts)

# Structured data -----------------------------------------------------------
prompts <- list(
  "I go by Alex. 42 years on this planet and counting.",
  "Pleased to meet you! I'm Jamal, age 27.",
  "They call me Li Wei. Nineteen years young.",
  "Fatima here. Just celebrated my 35th birthday last week.",
  "The name's Robert - 51 years old and proud of it.",
  "Kwame here - just hit the big 5-0 this year."
)
type_person <- type_object(name = type_string(), age = type_number())
parallel_chat_structured(chat, prompts, type_person)
\dontshow{\}) # examplesIf}
}
