% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provider-azure.R
\name{chat_azure}
\alias{chat_azure}
\title{Chat with a model hosted on Azure OpenAI}
\usage{
chat_azure(
  endpoint = azure_endpoint(),
  deployment_id,
  api_version = NULL,
  system_prompt = NULL,
  turns = NULL,
  api_key = azure_key(),
  token = NULL,
  api_args = list(),
  echo = c("none", "text", "all")
)
}
\arguments{
\item{endpoint}{Azure OpenAI endpoint url with protocol and hostname, i.e.
\verb{https://\{your-resource-name\}.openai.azure.com}. Defaults to using the
value of the \code{AZURE_OPENAI_ENDPOINT} envinronment variable.}

\item{deployment_id}{Deployment id for the model you want to use.}

\item{api_version}{The API version to use.}

\item{system_prompt}{A system prompt to set the behavior of the assistant.}

\item{turns}{A list of \link{Turn}s to start the chat with (i.e., continuing a
previous conversation). If not provided, the conversation begins from
scratch.}

\item{api_key}{The API key to use for authentication. You generally should
not supply this directly, but instead set the \code{AZURE_OPENAI_API_KEY} environment
variable.}

\item{token}{Azure token for authentication. This is typically not required for
Azure OpenAI API calls, but can be used if your setup requires it.}

\item{api_args}{Named list of arbitrary extra arguments appended to the body
of every chat API call.}

\item{echo}{One of the following options:
\itemize{
\item \code{none}: don't emit any output (default when running in a function).
\item \code{text}: echo text output as it streams in (default when running at
the console).
\item \code{all}: echo all input and output.
}

Note this only affects the \code{chat()} method.}
}
\value{
A \link{Chat} object.
}
\description{
The \href{https://azure.microsoft.com/en-us/products/ai-services/openai-service}{Azure OpenAI server}
hosts a number of open source models as well as proprietary models
from OpenAI.
}
\examples{
\dontrun{
chat <- chat_azure(deployment_id = "gpt-4o-mini")
chat$chat("Tell me three jokes about statisticians")
}
}
