% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{check_dots_empty}
\alias{check_dots_empty}
\title{Check that dots are unused}
\usage{
check_dots_empty(env = parent.frame())
}
\arguments{
\item{env}{Environment in which to look for \code{...}.}
}
\description{
Sometimes you just want to use \code{...} to force your users to fully name
the details arguments. This function warns if \code{...} is not empty.
}
\examples{
f <- function(x, ..., foofy = 8) {
  check_dots_empty()
  x + foofy
}

try(f(1, foof = 4))
f(1, foofy = 4)
}
