% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stopwords.R
\name{Stopwords}
\alias{Stopwords}
\title{Stopwords Class}
\description{
Stopwords is for filter result.
}
\examples{
\dontrun{
  Stopwords$new()
}

## ------------------------------------------------
## Method `Stopwords$add`
## ------------------------------------------------

 \dontrun{
  sw <- Stopwords$new()
  sw$add("word", "NNG")
  sw$add("word", Tags$nng)
  }
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-print}{\code{Stopwords$print()}}
\item \href{#method-new}{\code{Stopwords$new()}}
\item \href{#method-add}{\code{Stopwords$add()}}
\item \href{#method-add_from_dict}{\code{Stopwords$add_from_dict()}}
\item \href{#method-remove}{\code{Stopwords$remove()}}
\item \href{#method-save_user_dict}{\code{Stopwords$save_user_dict()}}
\item \href{#method-get}{\code{Stopwords$get()}}
\item \href{#method-clone}{\code{Stopwords$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
print method for \code{Stopwords} objects
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stopwords$print(x, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{self}

\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a stopwords object for filter stopwords on \code{\link[=analyze]{analyze()}} and \code{\link[=tokenize]{tokenize()}} results.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stopwords$new(use_system_dict = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use_system_dict}}{\code{bool(optional)}: use system stopwords dictionary or not.
Defualt is TRUE.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add"></a>}}
\if{latex}{\out{\hypertarget{method-add}{}}}
\subsection{Method \code{add()}}{
add stopword one at a time.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stopwords$add(form, tag = Tags$NNP)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{form}}{\code{char(required)}: Form information.}

\item{\code{tag}}{\code{char(optional)}: Tag information. Default is "NNP". Please check \link{Tags}.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ \dontrun{
  sw <- Stopwords$new()
  sw$add("word", "NNG")
  sw$add("word", Tags$nng)
  }
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_from_dict"></a>}}
\if{latex}{\out{\hypertarget{method-add_from_dict}{}}}
\subsection{Method \code{add_from_dict()}}{
add stopword from text file.
text file need to form "TEXT/TAG".
TEXT can remove like "/NNP".
TAG required like "FORM/NNP".
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stopwords$add_from_dict(path, dict_name = "user")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{\code{char(required)}: dictionary file path.}

\item{\code{dict_name}}{\code{char(optional)}: default is "user"}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-remove"></a>}}
\if{latex}{\out{\hypertarget{method-remove}{}}}
\subsection{Method \code{remove()}}{
remove stopword one at a time.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stopwords$remove(form = NULL, tag = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{form}}{\code{char(optional)}: Form information. If form not set, remove tag in input.}

\item{\code{tag}}{\code{char(required)}: Tag information. Please check \link{Tags}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-save_user_dict"></a>}}
\if{latex}{\out{\hypertarget{method-save_user_dict}{}}}
\subsection{Method \code{save_user_dict()}}{
save current stopwords list in text file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stopwords$save_user_dict(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{\code{char(required)}: file path to save stopwords list.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get"></a>}}
\if{latex}{\out{\hypertarget{method-get}{}}}
\subsection{Method \code{get()}}{
return tibble of stopwords.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stopwords$get()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a \link[tibble:tibble-package]{tibble} for stopwords options
for \code{\link[=analyze]{analyze()}} / \code{\link[=tokenize]{tokenize()}} function.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stopwords$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
