% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain.R
\name{explain}
\alias{explain}
\title{Explain a search query.}
\usage{
explain(
  conn,
  index,
  id,
  type = NULL,
  source2 = NULL,
  fields = NULL,
  routing = NULL,
  parent = NULL,
  preference = NULL,
  source = NULL,
  q = NULL,
  df = NULL,
  analyzer = NULL,
  analyze_wildcard = NULL,
  lowercase_expanded_terms = NULL,
  lenient = NULL,
  default_operator = NULL,
  source_exclude = NULL,
  source_include = NULL,
  body = NULL,
  raw = FALSE,
  ...
)
}
\arguments{
\item{conn}{an Elasticsearch connection object, see \code{\link[=connect]{connect()}}}

\item{index}{Only one index. Required}

\item{id}{Document id, only one. Required}

\item{type}{Only one document type, optional}

\item{source2}{(logical) Set to TRUE to retrieve the _source of the document
explained. You can also retrieve part of the document by using
source_include & source_exclude (see Get API for more details). This
matches the \verb{_source} term, but we want to avoid the leading underscore.}

\item{fields}{Allows to control which stored fields to return as part of
the document explained.}

\item{routing}{Controls the routing in the case the routing was used during
indexing.}

\item{parent}{Same effect as setting the routing parameter.}

\item{preference}{Controls on which shard the explain is executed.}

\item{source}{Allows the data of the request to be put in the query string
of the url.}

\item{q}{The query string (maps to the query_string query).}

\item{df}{The default field to use when no field prefix is defined within
the query. Defaults to _all field.}

\item{analyzer}{The analyzer name to be used when analyzing the query
string. Defaults to the analyzer of the _all field.}

\item{analyze_wildcard}{(logical) Should wildcard and prefix queries be
analyzed or not. Default: \code{FALSE}}

\item{lowercase_expanded_terms}{Should terms be automatically lowercased
or not. Default: \code{TRUE}}

\item{lenient}{If set to true will cause format based failures (like
providing text to a numeric field) to be ignored. Default: \code{FALSE}}

\item{default_operator}{The default operator to be used, can be AND or OR.
Defaults to OR.}

\item{source_exclude}{A vector of fields to exclude from the returned
source2 field}

\item{source_include}{A vector of fields to extract and return from the
source2 field}

\item{body}{The query definition using the Query DSL. This is passed in the
body of the request.}

\item{raw}{If \code{TRUE} (default), data is parsed to list. If \code{FALSE}, then
raw JSON.}

\item{...}{Curl args passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\description{
Explain a search query.
}
\examples{
\dontrun{
(x <- connect())

explain(x, index = "plos", id = 14, q = "title:Germ")

body <- '{
 "query": {
   "match": { "title": "Germ" }
 }
}'
explain(x, index = "plos", id = 14, body=body)
}
}
\references{
\url{https://www.elastic.co/guide/en/elasticsearch/reference/current/search-explain.html}
}
