% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsers.r
\name{es_parse}
\alias{es_parse}
\alias{es_parse.es_GET}
\alias{es_parse.index_delete}
\alias{es_parse.bulk_make}
\alias{es_parse.elastic_mget}
\alias{es_parse.elastic_search}
\alias{es_parse.elastic_status}
\alias{es_parse.elastic_stats}
\alias{es_parse.elastic_cluster_health}
\alias{es_parse.elastic_cluster_health}
\alias{es_parse.elastic_cluster_state}
\alias{es_parse.elastic_cluster_settings}
\alias{es_parse.elastic_cluster_stats}
\alias{es_parse.elastic_cluster_pending_tasks}
\alias{es_parse.elastic_nodes_stats}
\alias{es_parse.elastic_nodes_info}
\title{Parse raw data from es_get, es_mget, or es_search.}
\usage{
es_parse(input, parsetype, verbose)

\method{es_parse}{es_GET}(input, parsetype = "list", verbose = FALSE)

\method{es_parse}{index_delete}(input, parsetype = "list", verbose = FALSE)

\method{es_parse}{bulk_make}(input, parsetype = "list", verbose = FALSE)

\method{es_parse}{elastic_mget}(input, parsetype = "list", verbose = FALSE)

\method{es_parse}{elastic_search}(input, parsetype = "list",
  verbose = FALSE)

\method{es_parse}{elastic_status}(input, parsetype = "list",
  verbose = FALSE)

\method{es_parse}{elastic_stats}(input, parsetype = "list", verbose = FALSE)

\method{es_parse}{elastic_cluster_health}(input, parsetype = "list",
  verbose = TRUE)

\method{es_parse}{elastic_cluster_health}(input, parsetype = "list",
  verbose = TRUE)

\method{es_parse}{elastic_cluster_state}(input, parsetype = "list",
  verbose = TRUE)

\method{es_parse}{elastic_cluster_settings}(input, parsetype = "list",
  verbose = TRUE)

\method{es_parse}{elastic_cluster_stats}(input, parsetype = "list",
  verbose = TRUE)

\method{es_parse}{elastic_cluster_pending_tasks}(input, parsetype = "list",
  verbose = TRUE)

\method{es_parse}{elastic_nodes_stats}(input, parsetype = "list",
  verbose = TRUE)

\method{es_parse}{elastic_nodes_info}(input, parsetype = "list",
  verbose = TRUE)
}
\arguments{
\item{input}{Output from solr_facet}

\item{parsetype}{One of 'list' or 'df' (data.frame). Only list possible for now.}

\item{verbose}{Print messages or not (default: FALSE).}
}
\description{
Parse raw data from es_get, es_mget, or es_search.
}
\details{
This is the parser used internally in es_get, es_mget, and es_search,
but if you output raw data from es_* functions using raw=TRUE, then you can use this
function to parse that data (a es_* S3 object) after the fact to a list of
data.frame's for easier consumption.
}
\keyword{internal}
