% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrf_add.R
\name{wrf_add}
\alias{wrf_add}
\title{Function to add values for variables on emission files}
\usage{
wrf_add(file = file.choose(), name = NA, POL)
}
\arguments{
\item{file}{name of file interactively (default) or specified}

\item{name}{name of the variable (any variable)}

\item{POL}{variable to be written}
}
\description{
Add values to a variable in a netCDF file, the main use is to combine different
emissions like top-down emission (EmissV emissions) and inventary emission (sush as EDGAR,
GAINS, RETRO, etc).
}
\note{
this function might be deprecated in future
}
\examples{
{
# create the folder and emission file
dir.create(file.path(tempdir(), "EMISS"))
wrf_create(wrfinput_dir = system.file("extdata", package = "eixport"),
           wrfchemi_dir = file.path(tempdir(), "EMISS"))

# get the name of created file
files <- list.files(path = file.path(tempdir(), "EMISS"),
                    pattern = "wrfchemi",
                    full.names = TRUE)

# open, put some numbers and write
CO <- wrf_get(file = files[1], name = "E_CO")
CO[] = rnorm(length(CO),mean = 5,sd = 1)
wrf_put(file = files[1], name = "E_CO", POL = CO)
# open, put some different numbers and write
CO[] = rnorm(length(CO),mean = 10,sd = 1)
wrf_add(file = files[1], name = "E_CO", POL = CO)
}
}
\author{
Daniel Schuch
}
