% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emis_opt.R
\docType{data}
\name{emis_opt}
\alias{emis_opt}
\title{List of WRF emission species}
\format{A list of emision variables names, same number than emis_opt in namelist.}
\source{
\url{http://www2.mmm.ucar.edu/wrf/users/download/get_source.html}
}
\usage{
data(emis_opt)
}
\description{
Emission package definitions from WRF 3.9.1.1
}
\note{
look to the number of aerosol of the emis_opt in wrf domumentation / code.
}
\examples{
\dontrun{
# Do not run
dir.create("EMISS")
data(emis_opt)
names(emis_opt)
wrf_create(wrfinput_dir = system.file("extdata", package = "eixport"),
           wrfchemi_dir = "EMISS",
           variaveis    = emis_opt["eradmsorg"],
           n_aero       = 17)
}

}
\seealso{
\code{\link{to_wrf}}
}
\author{
Daniel Schuch
}
\keyword{datasets}
