% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{calcSummaryOutputValues_}
\alias{calcSummaryOutputValues_}
\title{Internal/private method. Compute bounds and summary statistics according to Jiang et al. 2019}
\usage{
calcSummaryOutputValues_(x, t, n, useXRangeOffset = TRUE)
}
\arguments{
\item{x}{Numeric (double-precision) vector. Contains the proportion of variable X in each precinct (or analagous geographic unit)}

\item{t}{Numeric (double-precision) vector. Contains the proportion of variable T in each precinct (or analagous geographic unit)}

\item{n}{Numeric (double-precision) vector. Contains the number of elements (people/households/etc.) in each precinct (or analagous geographic unit)}

\item{useXRangeOffset}{boolean If True, an offset of 0.00001 is applied to l and u to avoid division by 0 in subsequent calculations. Default TRUE.}
}
\value{
List object with the bounds and summary statistics
}
\description{
\code{calcSummaryOutputValues_()} is an internal/private helper method for calculating the bounds. Called by calcSummaryOutputValues().
}
\examples{
\dontrun{
outputList <- calcSummaryOutputValues_(x, t, n, TRUE)
}

}
