% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.hazdata.R
\name{plot.hazdata}
\alias{plot.hazdata}
\title{Plots of survivor functions.}
\usage{
\method{plot}{hazdata}(x, strata = NULL, fn = c("cum", "surv", "log",
  "loglog"), fig = TRUE, xlim = NULL, ylim = NULL, main = NULL,
  xlab = NULL, ylab = NULL, col = "black", lty = 1,
  printLegend = TRUE, where = NULL, ...)
}
\arguments{
\item{x}{A \code{hazdata} object, typically the 'hazards' element in the
output from \code{link{coxreg}} with \code{hazards = TRUE}.}

\item{strata}{Stratum names if there are strata present.}

\item{fn}{Which type of plot?}

\item{fig}{Should a plot actually be produced? Default is TRUE.}

\item{xlim}{Horizontal plot limits. If NULL, calculated by the function.}

\item{ylim}{Vertical plot limits. If NULL, set to \code{c(0, 1)}}

\item{main}{A heading for the plot.}

\item{xlab}{Label on the x axis.}

\item{ylab}{Label on the y-axis.}

\item{col}{Color of the lines. May be a vector of length equal to No. of
strata.}

\item{lty}{Line type(s). May be a vector of length equal to No. of strata.}

\item{printLegend}{Logical; should a legend be produced?  Defaults to TRUE.}

\item{where}{Where should the legend be placed (if(printLegend))?  If
\code{NULL}, "bottomleft" for fn = "surv", otherwise "bottomright".}

\item{...}{Anything that \code{\link[graphics]{plot.default}} likes...}
}
\value{
A list where the elements are two-column matrices, one for each
stratum in the model. The first column contains risktimes, and the second
the y coordinates for the requested curve(s).
}
\description{
Baseline hazards estimates.
}
\details{
It is also possible to have as first argument an object of type "coxreg",
given that it contains a component of type "hazdata".
}
\examples{

time0 <- numeric(50)
group <- c(rep(0, 25), rep(1, 25))
time1 <- rexp( 50, exp(group) )
event <- rep(1, 50)
fit <- coxreg(Surv(time0, time1, event) ~ strata(group), hazards = TRUE)
plot(fit$hazards)

}
\author{
Göran Broström
}
\keyword{survival}
