% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.surv.R
\name{plot.Surv}
\alias{plot.Surv}
\title{Plots of survivor functions.}
\usage{
\method{plot}{Surv}(x, strata = NULL, fn = c("cum", "surv", "log",
  "loglog"), limits = TRUE, conf = 0.95, main = NULL, xlab = NULL,
  ylab = NULL, xlim = NULL, ylim = NULL, lty = NULL, col = NULL,
  lty.con = NULL, col.con = NULL, x.axis = TRUE, printLegend = TRUE,
  ...)
}
\arguments{
\item{x}{A \code{Surv} object.}

\item{strata}{Defines a partition of the data. One survivor function for
each level of \code{strata} is drawn.}

\item{fn}{Which type of plot?}

\item{limits}{If TRUE, and if the number of curves is one, confidence limits
are drawn.}

\item{conf}{The confidence level for the confidence limits.}

\item{main}{A heading for the plot.}

\item{xlab}{Label on the x axis.}

\item{ylab}{Label on the y-axis.}

\item{xlim}{Horizontal plot limits. If NULL, calculated by the function.}

\item{ylim}{Vertical plot limits. If NULL, set to \code{c(0, 1)}}

\item{lty}{Line type of curves.}

\item{col}{Color of curves.}

\item{lty.con}{Line type of confidence bands.}

\item{col.con}{Color of confidence bands.}

\item{x.axis}{Should \code{abline(h=0)} be drawn?}

\item{printLegend}{Logical, defaults to \code{TRUE}. If \code{FALSE}, no
legend is printed, but can be added after plotting. To be used if the
default place for the legend fits badly.}

\item{...}{Anything that \code{plot} likes...}
}
\value{
No value is returned.
}
\description{
Kaplan-Meier estimates. If only one curve, confidence limits according to
Greenwood's formula are drawn.
}
\details{
Left truncation is allowed. Note, though, that this fact may result in
strange estimated curves due to lack of data in certain (low) ages.
}
\examples{

time0 <- numeric(50)
group <- c(rep(0, 25), rep(1, 25))
time1 <- rexp( 50, exp(group) )
event <- rep(1, 50)
plot(Surv(time0, time1, event), strata = group)

}
\author{
Göran Broström
}
\keyword{survival}
