% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piecewise.R
\name{piecewise}
\alias{piecewise}
\title{Piecewise hazards}
\usage{
piecewise(enter, exit, event, cutpoints)
}
\arguments{
\item{enter}{Left interval endpoint}

\item{exit}{Right interval endpoint}

\item{event}{Indicator of event}

\item{cutpoints}{Vector of cutpoints}
}
\value{
A list with components

\item{events}{Vector of number of events} \item{exposure}{Vector of total
exposure time} \item{intensity}{Vector of hazards, \code{intensity} ==
\code{events} / \code{exposure}}
}
\description{
Calculate piecewise hazards, no. of events, and exposure times in each
interval indicated by cutpoints.
}
\details{
Exact calculation.
}
\seealso{
\code{\link{perstat}}
}
\author{
Göran Broström
}
\keyword{nonparametric}
\keyword{survival}
