% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotHaz.R
\name{plotHaz}
\alias{plotHaz}
\title{Graphical comparing of cumulative hazards}
\usage{
plotHaz(
  sp,
  pp,
  interval,
  main = NULL,
  xlab = "Time",
  ylab = "Cum. hazards",
  leglab,
  col = c("blue", "red"),
  lty = 1:2,
  ylim,
  log = "",
  printLegend = TRUE
)
}
\arguments{
\item{sp}{An object of type "coxreg" or "phreg", typically output from
\code{\link{coxreg}} or \code{\link{phreg}}.}

\item{pp}{An object of type "coxreg" or "phreg", typically output from
\code{\link{coxreg}} or \code{\link{phreg}}.}

\item{interval}{Time interval for the plot, if missing, calculated from \code{sp}.}

\item{main}{Header for the plot. Default is distribution and "cumulative
hazard function"}

\item{xlab}{Label on x axis (default "Time")}

\item{ylab}{Label on y axis (default "Cum. Hazards")}

\item{leglab}{Labels in legend.}

\item{col}{Line colors. should be \code{NULL} (black lines) or of length 2}

\item{lty}{line types.}

\item{ylim}{Y limits for the plot.}

\item{log}{Argument sent to \code{plot}, defaults to "".}

\item{printLegend}{Should a legend be printed? Default is \code{TRUE}.}
}
\value{
No return value.
}
\description{
Comparison of the cumulative hazards functions for a semi-parametric and
parametric models.
}
\details{
For the moment only a graphical comparison. The arguments \code{sp} and
\code{pp} may be swapped.
}
\examples{

data(mort)
op <- par(mfrow = c(1, 2))
fit.cr <- coxreg(Surv(enter, exit, event) ~ ses, data = mort)
fit.w <- phreg(Surv(enter, exit, event) ~ ses, data = mort)
fit.g <- phreg(Surv(enter, exit, event) ~ ses, data = mort,
dist = "gompertz")
plotHaz(fit.cr, fit.w, interval = c(0, 20), main = "Weibull")
plotHaz(fit.cr, fit.g, main = "Gompertz")
par(op)

}
\seealso{
\code{\link{check.dist}}, \code{\link{coxreg}} and \code{\link{phreg}}.
}
\author{
Göran Broström
}
\keyword{distribution}
