% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmm.logo.R
\name{hmm.logo}
\alias{hmm.logo}
\title{Plots the relative frequencies of each position for \code{hmmsearch} table.}
\usage{
hmm.logo(hmm.table)
}
\arguments{
\item{hmm.table}{The HMM profile table resulting from \code{\link{hmm.search}}}
}
\description{
This function plots the results from \code{\link{hmm.search}} as a barplot with amino acids in the x axis and the relative frequency of each amino acid in the y axis
}
\examples{
\dontrun{

fasta.file <- system.file("extdata", "test_infestans.fasta", package = "effectR")
ORF <- seqinr::read.fasta(fasta.file)
REGEX <- regex.search(ORF, motif='RxLR')
candidate.rxlr <- hmm.search(original.seq = fasta.file, regex.seq=REGEX, num.threads = 2)
hmm.logo(candidate.rxlr$HMM_Table)
}
}
\keyword{effector}
\keyword{plot}
\keyword{regex}
