% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activity.r
\name{transprobs<-}
\alias{transprobs<-}
\alias{transprobs}
\title{Transition probabilities of an activity}
\usage{
transprobs(act) <- value

transprobs(act)
}
\arguments{
\item{act}{Activity definition}

\item{value}{\code{data.frame} of transition probabilities}
}
\value{
\code{data.frame} where prob is the transition probability from current
state (with suffix 0) to next state (with suffix 1).
}
\description{
Functions to get or set the transition probabilities of an activity
}
\details{
The \code{value} should be a \code{data.frame} defining the transition probabilities
between dynamic variables of the activity. See \code{\link{define_activity}}
for details
}
\examples{
act1 <- define_activity("test", c("vol"))
transprobs(act1) <- data.frame(vol0 = 1:5, vol1=c(2:5, 5), prob=1)
transprobs(act1)

if(require("ggplot2")) {
  ggplot(transprobs(act1)) + geom_raster(aes(x=vol0, y=vol1, fill=prob))
}
}
