% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activity.r
\name{build_statespace}
\alias{build_statespace}
\title{Add a statespace to an activity}
\usage{
build_statespace(act, statespace, factors = character(), by = character())
}
\arguments{
\item{act}{Activity definition}

\item{statespace}{\code{data.frame}}

\item{factors}{\code{character} Variables used by the activity}

\item{by}{\code{character} Variables that split the statespace}
}
\value{
Activity definition with statespace
}
\description{
Add a statespace to an activity
}
\details{
Statespace is the collection of strata. When it is added to an activity defined by define_activity
the following \code{\link{estimatetransprobs}} function has sufficient information to estimate transition
probabilties.

\code{factors} and \code{by} variables are used by \code{\link{estimatetransprobs}}
to estimate transition probabilities for strata. Observations with
different levels of \code{factors} variables are used where as observations
with different levels of \code{by} variables are never used.

If statespace is changing as a result of the activity see \code{\link{build_complex_statespace}}.
}
\examples{

statespacepine <- expand.grid(species="pine", vol=1:5, age=1:3, stringsAsFactors=FALSE)
statespacespruce <- expand.grid(species="spruce", vol=1:4, age=1:3, stringsAsFactors=FALSE)
statespace <- rbind(statespacepine, statespacespruce)
act <- define_activity("nomanagement", c("vol", "age"))
act <- build_statespace(act, statespace, by="species")
}
