% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mstBayes.R
\name{mstBayes}
\alias{mstBayes}
\title{Bayesian analysis of Multisite Randomised Education Trials (MST) using Vague Priors.}
\usage{
mstBayes(formula, random, intervention, nsim, data)
}
\arguments{
\item{formula}{The model to be analysed. It should be of the form y ~ x1 + x2 + ..., where y is the outcome variable and Xs are the predictors.}

\item{random}{A string specifying the "clustering variable" (e.g., schools or sites) as found in the dataset.}

\item{intervention}{A string specifying the "intervention variable" as it appears in the formula.}

\item{nsim}{Number of MCMC iterations to be performed. A minimum of 10,000 is recommended to ensure convergence.}

\item{data}{A data frame containing the variables referenced in the formula, including predictors, the clustering variable, and the intervention.}
}
\value{
S3 object; a list consisting of:
\itemize{
\item \code{Beta}: Estimates and credible intervals for the predictors specified in the model (posterior distributions).
\item \code{ES}: Hedges' g effect size for the intervention(s). If bootstrapping is not used, 95\% credible intervals are computed based on MCMC sampling.
\item \code{covParm}: Variance components broken down into between-cluster variance (e.g., between schools), within-cluster variance (e.g., within pupils), and intra-cluster correlation (ICC)..
\item \code{randomEffects}: Posterior estimates of random intercepts for each cluster (e.g., schools).
\item \code{ProbES}: A matrix showing the probability of observing an effect size larger than various thresholds (0, 0.05, 0.10, ...).
\item \code{Unconditional}: A list containing the unconditional effect size and variance decomposition.
}
}
\description{
\code{mstBayes} performs Bayesian multilevel analysis of multisite randomised education trials, utilising vague priors
and JAGS language to fit the model. It assumes hierarchical clustering, such as students within schools, and estimates
treatment effects while accounting for this structure.
}
\details{
The function provides posterior estimates for fixed effects (predictors) and random effects (clustering) under a Bayesian framework.
Effect sizes are computed using Hedges' g, and variance components are decomposed into between-cluster and within-cluster variances.
}
\examples{
if(interactive()){

  data(mstData)

  ########################################################
  ## Bayesian analysis of multisite randomised trials   ##
  ########################################################

  output <- mstBayes(formula = Posttest ~ Prettest + Intervention,
                     random = "School",
                     intervention = "Intervention",
                     nsim = 10000,
                     data = mstData)
  output

  ### Fixed effects
  beta <- output$Beta
  beta

  ### Effect size
  ES1 <- output$ES
  ES1

  ## Covariance matrix
  covParm <- output$covParm
  covParm

  ## Prob ES
  ProbES <- output$ProbES
  ProbES

  ## Unconditional
  Unconditional <- output$Unconditional
  Unconditional

  ## Random Effect
  randomEffects <- output$SchEffects
  randomEffects


  ### plot random effects for schools

  plot(output)

  ### plot posterior probability of an effect size to be bigger than a pre-specified threshold

  plot(output,group=1)


  #############################################################################################
  ## Bayesian analysis of multisite randomised trials using informative priors for treatment ##
  #############################################################################################

  ### define priors for explanatory variables

  my_prior <- normal(location = c(0,6), scale = c(10,1))

  ### specify the priors for the conditional model only

  output2 <- mstBayes(Posttest~ Prettest+Intervention,random="School",
                      intervention="Intervention",nsim=2000,data=mstData,
                      condopt=list(prior=my_prior))

  ### Fixed effects
  beta2 <- output2$Beta
  beta2

  ### Effect size
  ES2 <- output2$ES
  ES2
}
}
