% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cartogram.R
\name{circle}
\alias{circle}
\title{Draw a circle}
\usage{
circle(xvec, yvec, rvec, vertex = 100, border = 1, col = NULL,
  add = TRUE, square = FALSE, ...)
}
\arguments{
\item{xvec}{X-coordinates}

\item{yvec}{Y-coordinates}

\item{rvec}{Radii}

\item{vertex}{The number of vertices of the circle}

\item{border}{Color of border}

\item{col}{Color to render in circle}

\item{add}{Whether the circles are added to another plot.}

\item{square}{A logical value to determine whether to draw squares.}

\item{...}{other things}
}
\description{
##' From https://github.com/chxy/cartogram/blob/master/R/dorling.R
Not exported here, but needed for aec_carto_f
}
\details{
This function is used to compute the locations of the circle 
border and draw multiple circles. 
It borrows the code from plotrix::draw.circle
}
\examples{
\dontrun{
x=y=1:5
r=5:1/5
circle(x,y,r,add=FALSE,asp=1)
circle(x,y,r,vertex=6,add=TRUE)  # hexagon
circle(x,y,r,vertex=4,add=TRUE)  # diamond
circle(x,y,r,square=TRUE,add=TRUE)  # square
}

}
