% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecls-k-atl-data.R
\docType{data}
\name{items_ordered_eclsk_atl}
\alias{items_ordered_eclsk_atl}
\title{Subset of Early Childhood Longitudinal Study, Kindergarten (ECLS-K)'s
Approaches to Learning Item Responses}
\format{
An object of class \code{matrix} (inherits from \code{array}) with 13354 rows and 12 columns.
}
\usage{
items_ordered_eclsk_atl
}
\description{
Subset of Early Childhood Longitudinal Study, Kindergarten (ECLS-K)'s
Approaches to Learning Item Responses
}
\details{
Items were split between being answered by \strong{Parents} and \strong{Teachers}.
\itemize{
\item \strong{Parents}:
\itemize{
\item \code{P4SRS10}: Keep working at something until {he/she} is finished?
\item \code{P4SRS13}: Show interest in a variety of things?
\item \code{P4SRS15}: Concentrate on a task and ignore distractions?
\item \code{P4SRS18}: Help with chores?
\item \code{P4SRS22}: Eager to learn new things?
\item \code{P4SRS24}: Creative in work or in play?
}
\item \strong{Teachers}:
\itemize{
\item \code{T4SRS11}: Keeps belongings organized.
\item \code{T4SRS14}: Shows eagerness to learn new things.
\item \code{T4SRS15}: Works independently.
\item \code{T4SRS21}: Easily adapts to changes in routine.
\item \code{T4SRS23}: Persists in completing tasks.
\item \code{T4SRS24}: Pays attention well.
}
}
}
\section{Data pre-processing}{

The Early Childhood Longitudinal Study, Kindergarten (ECLS-K) has been
subset down both the number of observations and variables. In particular,
only observations without any missing values from a set of reduced
variables -- given above -- are included. If additional data is required,
please visit the data download page found in the reference section.
}

\section{Answer coding}{

Parents and teachers each answered a set of survey items involving a
likert scale that ranged from "1 = never" to "4 = very often" regarding the
subject. Within the teacher responses, they also  had the option of marking
"-7 = no opportunity to observe" option, which was treated as a missing
observation. To align with \emph{C++}, we perform a index shift backward of 1
and, thus, make the scale "0=never" to "3=very often".
}

\references{
\strong{Data originated from:}
\itemize{
\item NCES. (2010). \emph{Early childhood longitudinal study, kindergarten class of
1998-99 (ecls-k) kindergarten through fifth grade approaches to learning
and self-description questionnaire (sdq) items and public-use data
files}. \url{https://nces.ed.gov/pubsearch/pubsinfo.asp?pubid=2010070}
}

\strong{Data used in:}
\itemize{
\item Culpepper, S. (2019). An exploratory diagnostic model for ordinal
responses with binary attributes: Identifiability and estimation.
\emph{Psychometrika}, \emph{84}(4), 921–940.
\url{https://doi.org/10.1007/s11336-019-09683-4}
}
}
\keyword{datasets}
