% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demoApp.R
\name{runDemoApp}
\alias{runDemoApp}
\title{Run a demo app}
\usage{
runDemoApp(app = "database", ...)
}
\arguments{
\item{app}{demoApp to run. Options: database / mtcars / custom}

\item{...}{arguments passed onto the demoApp}
}
\value{
An object that represents the app. Printing the object or passing it
to \code{\link[shiny:runApp]{runApp()}} will run the app.
}
\description{
Run a demo app
}
\details{
These apps are for illustrative purposes.
}
\examples{
## Only run this example in interactive R sessions
if(interactive()){
 
  # Database
  tmpFile <- tempfile(fileext = ".sqlite")
  file.copy(system.file("extdata", "chinook.sqlite", package = 'editbl'), tmpFile)

  conn <- connectDB(dbname = tmpFile)

  runDemoApp(app = "database", conn = conn)
  DBI::dbDisconnect(conn)

  unlink(tmpFile)

  # mtcars
  runDemoApp(app = "mtcars")

  # Any tibble of your liking
  runDemoApp(app = "custom", dplyr::tibble(iris))
}
}
