% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edina.R
\name{edina}
\alias{edina}
\title{EDINA Estimation Routine}
\usage{
edina(data, k = 3, burnin = 10000, chain_length = 20000)
}
\arguments{
\item{data}{Binary responses to assessments in \code{matrix}
form with dimensions \eqn{N \times J}{N x J}.}

\item{k}{Number of Attribute Levels as a positive \code{integer}.}

\item{burnin}{Number of Observations to discard on the chain.}

\item{chain_length}{Length of the MCMC chain}
}
\value{
An \code{edina} object that contains:
\itemize{
\item \code{coefficients}: Estimated coefficients of the model fit
\item \code{loglike_summed}: Summed log-likelihood
\item \code{loglike_pmean}: Mean of log-likelihood
\item \code{pi_classes}: Latent classes
\item \code{avg_q}: Estimated Averaged Q Matrix
\item \code{est_q}: Estimated Dichotomous Q Matrix
\item \code{or_tested}: Odds Ratio used in the model selection.
\item \code{sample_or}: Odds Ratio for the sample.
\item \code{n}: Number of Observations
\item \code{j}: Number of Items
\item \code{k}: Number of Traits
\item \code{burnin}: Amount of iterations to discard
\item \code{chain_length}: Amount of iterations to retain.
\item \code{timing}: Duration of the run
\item \code{dataset_name}: Name of the data set used in estimation.
}
}
\description{
Performs the Exploratory Deterministic Input, Noise and Gate Model (EDINA)
estimation on a given data set with a prespecified \code{k} value.
}
\examples{
if(requireNamespace("simcdm", quietly = TRUE)) {

# Set a seed for reproducibility
set.seed(1512)

# Setup data simulation parameters
N = 1    # Number of Examinees / Subjects
J = 10   # Number of Items
K = 2    # Number of Skills / Attributes

# Note:
# Sample size and attributes have been reduced to create a minimally
# viable example that can be run during CRAN's automatic check.
# Please make sure to have a larger sample size...

# Assign slipping and guessing values for each item
ss = gs = rep(.2, J)

# Simulate an identifiable Q matrix
Q = simcdm::sim_q_matrix(J, K)

# Simulate subject attributes
subject_alphas = simcdm::sim_subject_attributes(N, K)

# Simulate items under the DINA model
items_dina = simcdm::sim_dina_items(subject_alphas, Q, ss, gs)

# Compute the edina model
edina_model = edina(items_dina, k = K)

# Display results
edina_model

# Provide a summary overview
summary(edina_model)
}

}
\seealso{
\code{\link[=auto_edina]{auto_edina()}},
\code{\link[=summary.edina]{summary.edina()}},
\code{\link[=print.edina]{print.edina()}}
}
