% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{label_seq}
\alias{label_seq}
\alias{label_seq_from_to}
\alias{label_seq_from_length}
\alias{label_seq_to_length}
\alias{label_seq_length}
\title{Generate a sequence of labels with custom formatting options}
\usage{
label_seq_from_to(
  from = 1L,
  to = 1L,
  by = 1L,
  prefix = "",
  suffix = "",
  sep_prefix = "",
  sep_suffix = "",
  leading_zero = edibble_labels_opt("leading_zero")
)

label_seq_from_length(
  from = 1L,
  length = 1L,
  by = 1L,
  prefix = "",
  suffix = "",
  sep_prefix = "",
  sep_suffix = "",
  leading_zero = edibble_labels_opt("leading_zero")
)

label_seq_to_length(
  to = 1L,
  length = 1L,
  by = 1L,
  prefix = "",
  suffix = "",
  sep_prefix = "",
  sep_suffix = "",
  leading_zero = edibble_labels_opt("leading_zero")
)

label_seq_length(
  length = 1L,
  prefix = "",
  suffix = "",
  sep_prefix = "",
  sep_suffix = "",
  leading_zero = edibble_labels_opt("leading_zero")
)
}
\arguments{
\item{from}{An integer specifying the starting value (inclusive) of the sequence.}

\item{to}{An integer specifying the ending value (inclusive) of the sequence.}

\item{by}{An integer specifying the increment between values in the sequence.}

\item{prefix}{A character string to be prepended to the labels.}

\item{suffix}{A character string to be appended to the labels.}

\item{sep_prefix}{A character string used to separate the prefix from the labels.}

\item{sep_suffix}{A character string used to separate the suffix from the labels.}

\item{leading_zero}{A logical value indicating whether to add leading zeros to the labels.
If integer, then pad based on the number supplied.}

\item{length}{An integer specifying the desired length of the sequence.}
}
\value{
A character vector containing the labels generated from the sequence.
}
\description{
These can be handy for generating pseudo labels for the levels or
factor names using \code{fct_generator}
}
\examples{
label_seq_to_length(to = 10, length = 5, by = 2)
label_seq_from_to(from = 8, to = 10, leading_zero = 3)
label_seq_length(10, leading_zero = FALSE)
}
