% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/units.R
\name{set_units}
\alias{set_units}
\title{Set units used in experiment}
\usage{
set_units(
  .edibble = design(),
  ...,
  .name_repair = c("check_unique", "unique", "universal", "minimal"),
  .record = TRUE
)
}
\arguments{
\item{.edibble}{An edibble design (\code{edbl_design}), an edibble data frame (\code{edbl_table}) or an
object that contains the edibble data frame in the attribute
\code{design}.}

\item{...}{Either a name-value pair or a series of the names.}

\item{.name_repair}{Same as the argument in \code{tibble::tibble()}.}

\item{.record}{A logical value. This indicates whether to record this
code step. The default is TRUE. It should remain TRUE unless this
function is used as a wrapper in other code.}
}
\value{
An edibble design.
}
\description{
This function sets new edibble variables of class \code{edbl_unit}. More
specifically, this means that new nodes are added to the \code{edbl_graph}.
}
\section{Definition of \emph{unit}}{

A \emph{unit}, much like \emph{factor}, is an over-used word but due to lack of a
better word, edibble uses the word "unit" to refer to any entity, physical
or otherwise, that pertain to the experiment. This function doen't
explicitly distinguish between experimental or observational units,
nor is a unit limited to these type of units.
A unit in edibble can be a blocking factor or even a discrete time unit.
}

\section{Limitations}{

Currently a unit should only have a discrete set of levels and
you need to know the number of levels prior to setting the units.
}

\examples{
# 30 rats
design() \%>\%
  set_units(rat = 30) \%>\%
  serve_table()

# 4 girls named "Anna", "Betty", "Carol", "Diana"
design() \%>\%
  set_units(girl = c("Anna", "Betty", "Carol", "Diana")) \%>\%
  serve_table()

# 3 companies, with 10 boxes each
design() \%>\%
  set_units(company = c("A", "B", "C"),
                box = nested_in(company, 10))

# 2 classes, one with 10 students, the other with 20 students
design() \%>\%
  set_units(class = 2,
            student = nested_in(class,
                                1 ~ 10,
                                2 ~ 20))

# 4 countries with 10 people from Australia & New Zealand and 20 from the rest
design() \%>\%
  set_units(country = c("AU", "NZ", "USA", "JPN"),
            person = nested_in(country,
                               c("AU", "NZ") ~ 10,
                                           . ~ 20)) \%>\%
  serve_table()


}
\seealso{
Other user-facing functions: 
\code{\link{allot_trts}()},
\code{\link{allot_units}()},
\code{\link{design}()},
\code{\link{expect_rcrds}()},
\code{\link{export_design}()},
\code{\link{serve_table}()},
\code{\link{set_rcrds}()},
\code{\link{set_trts}()}
}
\concept{user-facing functions}
