% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSentiment.R
\name{getSentiment}
\alias{getSentiment}
\title{Provides sentiment measures of EDGAR filings}
\usage{
getSentiment(cik.no, form.type, filing.year)
}
\arguments{
\item{cik.no}{vector of CIK number of firms in integer format. Suppress leading 
zeroes from CIKs. Keep cik.no = 'ALL' if needs to download for all CIKs.}

\item{form.type}{character vector containing form type to be downloaded. 
form.type = 'ALL' if need to download all forms.}

\item{filing.year}{vector of four digit numeric year}
}
\value{
Function returns dataframe containing CIK number, company name, 
date of filing, accession number, and various sentiment measures. 
This function takes the help of Loughran-McDonald (L&M) sentiment 
dictionaries (https://sraf.nd.edu/textual-analysis/resources/) to 
compute sentiment measures of a EDGAR filing. Following are the 
definitions of the text characteristics and the sentiment measures:

file.size = Total number of words in the filing. It does not consider stop words.

char.count = Total number of characters in the filing. It does not consider stop words.

complex.word.count = Total number of complex words in filing. A word is count 
as a complex word if contains vowels(a, e, i, o, u) more than three times. 
It does not consider stop words. 

lm.dictionary.count = The number of words that occur in the L&M master dictionary.

lm.negative.count = The number of L&M Financial-Negative words in the filing.

lm.positive.count = The number of L&M Financial-Positive words in the filing.

lm.strong.modal.count = The number of L&M Financial-Strong Modal words in the filing.

lm.moderate.modal.count = The number of L&M Financial-Moderate Modal words in the filing.

lm.weak.modal.count = The number of L&M Financial-Weak Modal words in the filing.

lm.uncertainty.count = The number of L&M Financial-Uncertainty words in the filing.

lm.litigious.count =  The number of L&M Financial-Litigious words in the filing.

harvard.negative.count = Number of words in the filing. that occur in the Harvard 
General Inquirer Negative word list, as defined by L&M.
}
\description{
\code{getSentiment} computes sentiment measures of EDGAR filings
}
\details{
getSentiment function takes CIK(s), form type(s), and year(s) as input parameters.  
The function first imports available downloaded filings in local woking directory 
'Edgar filings' created by \link[edgar]{getFilings} function; otherwise, 
it downloads the filings which is not already been downloaded.
It then reads the filings, cleans the filings, and 
computes the sentiment measures. The function returns a dataframe
with filing information, and sentiment measures.
}
\examples{
\dontrun{

senti.df <- getSentiment(cik.no = c('1000180', '38079'), 
                         form.type = '10-K', filing.year = 2006) 
                         
## Returns dataframe with sentiment measures of firms with CIKs 
1000180 and 38079 filed in year 2006 for form type '10-K'.

senti.df <- getSentiment(cik.no = '38079', form.type = c('10-K', '10-Q'), 
                         filing.year = c(2005, 2006))
}
}
